package javaxml3.ch13;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSLFilter implements Filter
{

	private Pattern hrefPattern;

	private SAXParserFactory saxParserFactory;

	private TransformerFactory transformerFactory;

	private Pattern typePattern;

	public void destroy()
	{
	}

	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException
	{
		if (request instanceof HttpServletRequest)
		{
			if (isLynxRequest((HttpServletRequest)request))
			{
				CharResponseWrapper wrapper = new CharResponseWrapper(
						(HttpServletResponse)response);
				chain.doFilter(request, wrapper);
				String xml = wrapper.toString();

				// Przetwarzaj tylko odpowiedzi XML.
				if ("text/xml".equals(wrapper.getContentType()))
				{
					String stylesheetHref = getStylesheetHref(xml);
					if (stylesheetHref != null)
					{
						response.setContentType("text/html");
						transformResponse(response, xml, stylesheetHref);
					}
					else
					{
						response.getWriter().print(xml);
					}
				}
				else
				{
					response.getWriter().print(xml);
				}
			}
			else
			{
				chain.doFilter(request, response);
			}
		}
		else
		{
			chain.doFilter(request, response);
		}
	}

	private String getStylesheetHref(String xml)
	{
		StylesheetPIHandler handler = new StylesheetPIHandler();
		try
		{
			SAXParser parser = saxParserFactory.newSAXParser();
			InputSource input = new InputSource(new StringReader(xml));
			parser.parse(input, handler);

			return handler.getHref();
		}
		catch (Exception e)
		{
			return null;
		}
	}

	public void init(FilterConfig config) throws ServletException
	{
		saxParserFactory = SAXParserFactory.newInstance();
		transformerFactory = TransformerFactory.newInstance();
		typePattern = Pattern.compile(".*type\\s*=\\s*\"(\\S*)\".*");
		hrefPattern = Pattern.compile(".*href\\s*=\\s*\"(\\S*)\".*");
	}

	private boolean isLynxRequest(HttpServletRequest request)
	{
		String userAgent = request.getHeader("User-Agent");
		return (userAgent.indexOf("Lynx") >= 0);
	}

	private void transformResponse(ServletResponse response, String xml,
			String stylesheetHref) throws IOException, ServletException
	{
		StreamSource sheetSource = new StreamSource(stylesheetHref);
		StreamSource xmlSource = new StreamSource(new StringReader(xml));
		StreamResult result = new StreamResult(response.getWriter());
		try
		{
			Transformer trans = transformerFactory.newTransformer(sheetSource);
			trans.transform(xmlSource, result);
		}
		catch (TransformerException e)
		{
			throw new ServletException("Nie mona wykona transformacji.", e);
		}
	}

	class CharResponseWrapper extends HttpServletResponseWrapper
	{
		private CharArrayWriter output;

		public CharResponseWrapper(HttpServletResponse response)
		{
			super(response);
			output = new CharArrayWriter();
		}

		public ServletOutputStream getOutputStream() throws IOException
		{
			return new ServletOutputStream()
			{

				public void write(int b) throws IOException
				{
					output.write(b);
				}

			};
		}

		public PrintWriter getWriter()
		{
			return new PrintWriter(output);
		}

		public String toString()
		{
			return output.toString();
		}
	}

	class StylesheetPIHandler extends DefaultHandler
	{

		private String href = null;

		public String getHref()
		{
			return href;
		}

		public void processingInstruction(String target, String data)
                throws SAXException
		{
			if ("xml-stylesheet".equals(target))
			{
				Matcher typeMatcher = typePattern.matcher(data);
				if (typeMatcher.matches()
						&& "text/xsl".equals(typeMatcher.group(1)))
				{
					Matcher hrefMatcher = hrefPattern.matcher(data);
					if (hrefMatcher.matches())
						href = hrefMatcher.group(1);
				}
			}
		}
	}
}
