package javaxml3;

import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.contrib.helpers.XPathHelper;

public class XPathDisplayNode {

    /** Wierzchoek JDOMNode na ktrym oparte jest to XPath. */
    JDOMNode node;

    public XPathDisplayNode(JDOMNode node) {
        this.node = node;
    }

    public String getXPath() throws JDOMException {
        // Obsuga elementw.
        if (node.getNode() instanceof Element) {
            return XPathHelper.getPathString((Element) node.getNode());
        }

        // Obsuga atrybutw.
        if (node.getNode() instanceof Attribute) {
            return XPathHelper.getPathString((Attribute) node.getNode());
        }

        // Obsuga tekstu.
        if (node.getNode() instanceof Text) {
            return XPathHelper.getPathString((Text) node.getNode());
        }

        // Inne typy wierzchokw.
        return "Ten typ wierzchoka nie jest jeszcze obsugiwany.";

    }
}
