package javaxml3;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/**
 * Klasa implementacyjna serwletu dla serwletu UpdateItemServlet.
 * 
 */
public class UpdateItemServlet extends javax.servlet.http.HttpServlet implements
        javax.servlet.Servlet {
    private String outputDir;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        outputDir = config.getInitParameter("OutputDirectory");
        if (outputDir == null)
            outputDir = "";
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException {

		// Pobieranie danych wyjciowych.
        PrintWriter out = res.getWriter();
        res.setContentType("text/html");

		// Wysyanie HTML.
        out.println("<html>");
        out.println(" <head><title>Input/Update Item Listing</title></head>");
        out.println(" <body>");
        out.println("  <h1 align='center'>Input/Update Item Listing</h1>");
        out.println("  <p align='center'>");
        out.println("   <form method='POST' action='" + "/ch05/UpdateItemServlet" + "'>");
        out.println("    Item ID (Unique Identifier): <br />");
        out.println("    <input name='id' type='text' maxLength='10' />"
                + "<br /><br />");
        out.println("    Item Name: <br />");
        out.println("    <input name='name' type='text' maxLength='50' />"
                + "<br /><br />");
        out.println("    Item Description: <br />");
        out.println("    <textarea name='description' rows='10' cols='30' "
                + "wrap='wrap' ></textarea><br /><br />");
        out.println("    <input type='reset' value='Reset Form'>&nbsp;&nbsp;");
        out.println("    <input type='submit' value='Add/Update Item' />");
        out.println("   </form>");
        out.println("  </p>");
        out.println(" </body>");
        out.println("</html>");
        out.close();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException {

		// Sprawdzanie wartoci parametrw.
        String id = req.getParameter("id");
        String name = req.getParameter("name");
        String description = req.getParameter("description");

		// Tworzenie nowego drzewa DOM.
        DOMImplementation domImpl = new DOMImplementationImpl();
        Document doc = domImpl.createDocument(null, "item", null);
        Element root = doc.getDocumentElement();

		// Identyfikator przedmiotu (jako atrybut).
        root.setAttribute("id", id);

        // Name of item
        Element nameElement = doc.createElement("name");
        Text nameText = doc.createTextNode(name);
        nameElement.appendChild(nameText);
        root.appendChild(nameElement);

		// Nazwa przedmiotu.
        Element descriptionElement = doc.createElement("description");
        Text descriptionText = doc.createTextNode(description);
        descriptionElement.appendChild(descriptionText);
        root.appendChild(descriptionElement);

		// Serializacja drzewa DOM.
        DOMSerializer serializer = new DOMSerializer();
        String filename = outputDir + "item-" + id + ".xml";
        File outputFile = new File(filename);
        serializer.serialize(doc, outputFile);

		// Drukowanie potwierdzenia.
        PrintWriter out = res.getWriter();
        res.setContentType("text/html");
        out.println("<HTML><BODY>");
        out.println("<p>Thank you for your submission. "
                + "Your item has been processed.</p>");
        out.println("<p>Your item was saved as " + outputFile.getAbsolutePath()
                + "</p>");
        out.println("</BODY></HTML>");
        out.close();
    }

}