package javaxml3;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


// Importy parsera.
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.parsers.DOMParser;


// Importy DOM.
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import org.xml.sax.SAXException;


public class ModifyItemServlet
    extends HttpServlet {

    private String outputDir;

    public void init(ServletConfig config)
              throws ServletException {
        super.init(config);
        outputDir = config.getInitParameter("OutputDirectory");

        if (outputDir == null)
            outputDir = "";
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res)
               throws ServletException, IOException {

		// Pobieranie danych wyjciowych.
        PrintWriter out = res.getWriter();
        res.setContentType("text/html");

		// Wysyanie HTML.
        out.println("<html>");
        out.println(" <head><title>Input/Update Item Listing</title></head>");
        out.println(" <body>");
        out.println("  <h1 align='center'>Input/Update Item Listing</h1>");
        out.println("  <p align='center'>");
        out.println("   <form method='POST' action='" + "/ch05/UpdateItemServlet" + "'>");
        out.println("    Item ID (Unique Identifier): <br />");
        out.println("    <input name='id' type='text' maxLength='10' />" + "<br /><br />");
        out.println("    Item Name: <br />");
        out.println("    <input name='name' type='text' maxLength='50' />" + "<br /><br />");
        out.println("    Item Description: <br />");
        out.println("    <textarea name='description' rows='10' cols='30' " + 
                "wrap='wrap' ></textarea><br /><br />");
        out.println("    <input type='reset' value='Reset Form'>&nbsp;&nbsp;");
        out.println("    <input type='submit' value='Add/Update Item' />");
        out.println("   </form>");
        out.println("  </p>");
        out.println(" </body>");
        out.println("</html>");
        out.close();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res)
                throws ServletException, IOException {

		// Sprawdzanie wartoci parametrw.
        String id = req.getParameter("id");
        String name = req.getParameter("name");
        String description = req.getParameter("description");

		// Sprawdzenie czy plik istnieje.
        Document doc = null;
        String filename = outputDir + "item-" + id + ".xml";
        File outputFile = new File(filename);

        if (!outputFile.exists()) {

			// Utworzenie nowego drzewa DOM.
            DOMImplementation domImpl = new DOMImplementationImpl();
            doc = domImpl.createDocument(null, "item", null);

            Element root = doc.getDocumentElement();

			// Identyfikator elementu (jako atrybut).
            root.setAttribute("id", id);

			// Nazwa elementu.
            Element nameElement = doc.createElement("name");
            Text nameText = doc.createTextNode(name);
            nameElement.appendChild(nameText);
            root.appendChild(nameElement);

			// Opis elementu.
            Element descriptionElement = doc.createElement("description");
            Text descriptionText = doc.createTextNode(description);
            descriptionElement.appendChild(descriptionText);
            root.appendChild(descriptionElement);
        } else {

			// adowanie dokumentu.
            try {

                DOMParser parser = new DOMParser();
                parser.parse(outputFile.toURL().toString());
                doc = parser.getDocument();

                Element root = doc.getDocumentElement();

				// Nazwa elementu.
                NodeList nameElements = root.getElementsByTagName("name");
                Element nameElement = (Element)nameElements.item(0);
                Text nameText = (Text)nameElement.getFirstChild();
                nameText.setData(name);

				// Opis elementu.
                NodeList descriptionElements = root.getElementsByTagName("description");
                Element descriptionElement = (Element)descriptionElements.item(0);

				// Usunicie i ponowne utworzenie opisu.
                root.removeChild(descriptionElement);
                descriptionElement = doc.createElement("description");

                Text descriptionText = doc.createTextNode(description);
                descriptionElement.appendChild(descriptionText);
                root.appendChild(descriptionElement);
            } catch (SAXException e) {

				// Drukowanie informacji o bdzie.
                PrintWriter out = res.getWriter();
                res.setContentType("text/html");
                out.println(
                        "<HTML><BODY>Error in reading XML: " + e.getMessage() + 
                        ".</BODY></HTML>");
                out.close();

                return;
            }
        }

		// Serializacja drzewa DOM.
        DOMSerializer serializer = new DOMSerializer();
        serializer.serialize(doc, outputFile);

		// Drukowanie potwierdzenia.
        PrintWriter out = res.getWriter();
        res.setContentType("text/html");
        out.println("<HTML><BODY>");
        out.println("<p>Thank you for your submission. " + "Your item has been processed.</p>");
        out.println("<p>Your item was saved as " + outputFile.getAbsolutePath() + "</p>");
        out.println("</BODY></HTML>");
        out.close();
    }
}
