package javaxml3.ch13;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class PostServlet extends HttpServlet
{

	private SAXBuilder builder = new SAXBuilder();

	private XPath nameXPath;

	private XPath yearXPath;

	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException
	{
		if (!"text/xml".equals(request.getContentType()))
		{
			response.getWriter().println("Przelij prosz jako text/xml.");
		}
		else
		{
			try
			{
				Document doc = builder.build(request.getReader());
				StringBuffer buff = new StringBuffer();
				buff.append("Szukano nazwy '" + nameXPath.valueOf(doc)
						+ "'");
				String year = yearXPath.valueOf(doc);
				if (!"notselected".equals(year))
				{
					buff.append(" i roku '" + year + "'");
				}
				buff.append(".");
				response.getWriter().print(buff.toString());
			}
			catch (JDOMException e)
			{
				response.getWriter().print(
						"Bd uzyskiwania kryteriw szukania: " + e.getMessage());
			}
		}
	}

	public void init() throws ServletException
	{
		try
		{
			nameXPath = XPath.newInstance("/search/name/text()");
			yearXPath = XPath.newInstance("/search/year/text()");
		}
		catch (JDOMException e)
		{
			throw new ServletException("Nie mona utworzy wyrae XPath.", e);
		}
		super.init();
	}
}