package javaxml3;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

/**
 * Klasa implementacyjna serwletu BookServlet
 * 
 */
public class BookServlet extends HttpServlet implements Servlet {

    private Document document;

    private SAXBuilder saxBuilder;

    private XMLOutputter outputter;

    public void init() throws ServletException {
        saxBuilder = new SAXBuilder();
        outputter = new XMLOutputter();

        String sourceFile = getInitParameter("sourceFile");
        if (sourceFile == null) {
            log("Parametr sourceFile nie zosta podany. Rozpoczynanie od pustego dokumentu.");
            document = new Document(new Element("books"));
        } else {
            InputStream instream = getServletContext().getResourceAsStream(
                    sourceFile);
            try {
                document = saxBuilder.build(instream);
            } catch (Exception e) {
                throw new ServletException("Nie mona utworzy dokumentu z "
                        + sourceFile, e);
            }
        }
    }

    /*
     * (non-Java-doc)
     * 
     * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request,
     *      HttpServletResponse response)
     */
    protected void doGet(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {
        outputDocument(response.getOutputStream());
    }

    private void outputDocument(OutputStream outStream) throws IOException {
        outputter.output(document, outStream);
    }

    /*
     * (non-Java-doc)
     * 
     * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request,
     *      HttpServletResponse response)
     */
    protected void doPost(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {
        if ("text/xml".equals(request.getContentType())) {
            Document input = null;
            try {
                input = saxBuilder.build(request.getInputStream());
            } catch (JDOMException e) {
                outputErrorDocument("Nie mona dokona analizy skadni danych wejciowych: " + e.getMessage(),
                        response.getOutputStream());
            }
            Element inputElement = input.detachRootElement();
            if (inputElement.getName().equals("book")) {
                document.getRootElement().addContent(inputElement);
            } else {
                outputErrorDocument("Nieprawidowy element korzenia, powinien by book.",
                        response.getOutputStream());
            }
        }
        outputDocument(response.getOutputStream());
    }

    private void outputErrorDocument(String errorString, OutputStream outStream)
            throws IOException {
        Document errorDoc = new Document();
        Element error = new Element("error");
        error.setText(errorString);

        outputter.output(document, outStream);
    }
}