package javaxml3;

import java.io.File;

import javax.xml.XMLConstants;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

import com.example.person.Person;

public class MarshalValidation {

    public static void main(String[] args) throws Exception {
		// Utworzenie niepenego obiektu Person.
        Person p = new Person();
        p.setFirstName("Burt");
        p.setLastName("Hires");

		// Tworzenie klasy transformujcej.
        JAXBContext context = JAXBContext.newInstance(Person.class);
        Marshaller marshaller = context.createMarshaller();

		// Tworzenie schematu.
        SchemaFactory sf = SchemaFactory
                .newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
        Schema schema = sf.newSchema(new File("person.xsd"));

		// Przypisanie schematu do klasy transformujcej.
        marshaller.setSchema(schema);
        marshaller.setEventHandler(new ValidationEventHandler() {

            public boolean handleEvent(ValidationEvent event) {
                System.out.println(event);
                return false;
            }});

			// To spowoduje wyjtek javax.xml.bind.MarshalException.
        marshaller.marshal(p, System.out);
    }

}
