package javaxml3;

import java.io.File;
import java.io.FileInputStream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class NextExample {

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: java javaxml3.NextExample "
                    + "[XML Document]");
            return;
        }
        File file = new File(args[0]);

        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLStreamReader reader = inputFactory
                .createXMLStreamReader(new FileInputStream(file));

        int eventTypeID = reader.next();

		// Pominicie wszystkich pocztkowych biaych znakw.
        while (reader.getEventType() == 6)
            reader.next();

		// Kursor znajduje si teraz na pocztku elementu person.

        eventTypeID = reader.next();
		// Kursor jest teraz na biaym znaku pomidzy elementami contact i name.

        eventTypeID = reader.next();
		// Kursor jest teraz na elemencie pocztkowym.

        eventTypeID = reader.next();
		// Kursor jest teraz na biaym znaku pomidzy elementami name i first_name.

        eventTypeID = reader.next();
		// Kursor jest teraz na pocztku elementu first_name.

        eventTypeID = reader.next();
		// Kursor powinien teraz by na tekcie wewntrz elementu first_name.

        System.out.println("Witaj " + reader.getText());
    }
}
