package javaxml3;

import java.awt.BorderLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StAXStreamTreeViewer extends JFrame {
	/** Podstawowe drzewo do wizualizacji. */
    private JTree jTree;

	/** Model drzewa do uycia. */
    DefaultTreeModel defaultTreeModel;

    public StAXStreamTreeViewer() {
		// Ustawienia Swing.
        super("StAX Tree Viewer");
        setSize(800, 450);
        // setSize(600, 200);
    }

    public void init(File file) throws XMLStreamException,
            FileNotFoundException {
        DefaultMutableTreeNode base = new DefaultMutableTreeNode(
                "XML Document: " + file.getAbsolutePath());

		// Tworzenie modelu drzewa.
        defaultTreeModel = new DefaultTreeModel(base);
        jTree = new JTree(defaultTreeModel);

		// Konstrukcja hierarchii drzewa
        buildTree(defaultTreeModel, base, file);

		// Wywietlenie wynikw.
        getContentPane().add(new JScrollPane(jTree), BorderLayout.CENTER);
    }

	// Metody i zmienne zwizane z pakietem Swing, wliczajc
	// ustawianie JTree i podstawowej powierzchni zawartoci.

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.out.println("Usage: java javaxml3.StAXStreamTreeViewer "
                        + "[XML Document]");
                return;
            }
            StAXStreamTreeViewer viewer = new StAXStreamTreeViewer();
            File f = new File(args[0]);

            viewer.init(f);
            viewer.setVisible(true);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void buildTree(DefaultTreeModel treeModel,
            DefaultMutableTreeNode current, File file)
            throws XMLStreamException, FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(file);
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLStreamReader reader = inputFactory
                .createXMLStreamReader(inputStream);

        addStartDocumentNodes(reader, current);

        parseRestOfDocument(reader, current);
    }

    private void addStartDocumentNodes(XMLStreamReader reader,
            DefaultMutableTreeNode current) {
        DefaultMutableTreeNode version = new DefaultMutableTreeNode(
                "XML Version: " + reader.getVersion());
        current.add(version);

        DefaultMutableTreeNode standalone = new DefaultMutableTreeNode(
                "Standalone? " + reader.isStandalone());
        current.add(standalone);

        DefaultMutableTreeNode standaloneSet = new DefaultMutableTreeNode(
                "Was Standalone Set? " + reader.standaloneSet());
        current.add(standaloneSet);

        DefaultMutableTreeNode encoding = new DefaultMutableTreeNode(
                "Encoding: " + reader.getEncoding());
        current.add(encoding);

        DefaultMutableTreeNode declaredEncoding = new DefaultMutableTreeNode(
                "Declared Encoding: " + reader.getCharacterEncodingScheme());
        current.add(declaredEncoding);
    }

    private void parseRestOfDocument(XMLStreamReader reader,
            DefaultMutableTreeNode current) throws XMLStreamException {

        while (reader.hasNext()) {
            int type = reader.next();
            switch (type) {
            case XMLStreamConstants.START_ELEMENT:

                DefaultMutableTreeNode element = new DefaultMutableTreeNode(
                        "Element: " + reader.getLocalName());
                current.add(element);
                current = element;

				// Okrelenie przestrzeni nazw.
                if (reader.getNamespaceURI() != null) {
                    String prefix = reader.getPrefix();
                    if (prefix == null) {
                        prefix = "[None]";
                    }
                    DefaultMutableTreeNode namespace = new DefaultMutableTreeNode(
                            "Namespace: prefix = '" + prefix + "', URI = '"
                                    + reader.getNamespaceURI() + "'");
                    current.add(namespace);
                }

                if (reader.getAttributeCount() > 0) {
                    for (int i = 0; i < reader.getAttributeCount(); i++) {
                        DefaultMutableTreeNode attribute = new DefaultMutableTreeNode(
                                "Attribute (name = '"
                                        + reader.getAttributeLocalName(i)
                                        + "', value = '"
                                        + reader.getAttributeValue(i) + "')");
                        String attURI = reader.getAttributeNamespace(i);
                        if (attURI != null) {
                            String attPrefix = reader.getAttributePrefix(i);
                            if (attPrefix == null || attPrefix.equals("")) {
                                attPrefix = "[None]";
                            }
                            DefaultMutableTreeNode attNamespace = new DefaultMutableTreeNode(
                                    "Namespace: prefix = '" + attPrefix
                                            + "', URI = '" + attURI + "'");
                            attribute.add(attNamespace);
                        }
                        current.add(attribute);
                    }
                }

                break;
            case XMLStreamConstants.END_ELEMENT:
                current = (DefaultMutableTreeNode) current.getParent();
                break;
            case XMLStreamConstants.CHARACTERS:
                if (!reader.isWhiteSpace()) {
                    DefaultMutableTreeNode data = new DefaultMutableTreeNode(
                            "Character Data: '" + reader.getText() + "'");
                    current.add(data);
                }
                break;
            case XMLStreamConstants.DTD:
                DefaultMutableTreeNode dtd = new DefaultMutableTreeNode(
                        "DTD: '" + reader.getText() + "'");
                current.add(dtd);
                break;
            case XMLStreamConstants.SPACE:
				// Zignorujmy to.
                break;
            case XMLStreamConstants.COMMENT:
                DefaultMutableTreeNode comment = new DefaultMutableTreeNode(
                        "Comment: '" + reader.getText() + "'");
                current.add(comment);
                break;
            default:
                System.out.println(type);
            }
        }
    }

}
