package javaxml3;

import org.xml.sax.InputSource;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.module.itunes.FeedInformation;
import com.sun.syndication.feed.module.itunes.ITunes;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedInput;

public class OutputOwnerEmail {

    public static void main(String[] args) throws FeedException {
        if (args.length != 1) {
            System.err.println("Uycie: java javaxml3.OutputOwnerEmail [url]");
            return;
        }

        WireFeedInput input = new WireFeedInput();

		// Najpierw analizujemy skadni rda.
        WireFeed feed = input.build(new InputSource(args[0]));

		// Nastpnie uzyskujemy modu dla URI iTunes.
        FeedInformation feedInfo = (FeedInformation) feed.getModule(ITunes.URI);
        if (feedInfo != null)
            System.out.println(feedInfo.getOwnerEmailAddress());
        else
            System.out.println("No iTunes module available");
    }

}
