package javaxml3;

import java.util.Collections;
import java.util.Iterator;

// Importy JDOM.
import org.jdom.Element;
import org.jdom.Text;

public class TextNode implements JDOMNode {

    /** Wierzchoek tekstowy decorated. */
    protected Text decorated;

    /** Rcznie ustawiony rodzic treci tego acucha. */
    private Element parent = null;
    
    public TextNode(Text text) {
        decorated = text;
    }

    public Object getNode() {
        return decorated;
    }

    public String getNodeName() {
        return "";
    }

    public JDOMNode getParentNode() {
        if (parent == null) {
            throw new RuntimeException(
                    "Rodzic treci tego acucha nie jest ustawiony!");
        }
        return new ElementNode(parent);
    }

    public String getQName() {
        // Wierzchoki tekstowe nie maj nazw.
        return "";
    }

    public Iterator iterator() {
        return Collections.EMPTY_LIST.iterator();
    }

    public TextNode setParent(Element parent) {
        this.parent = parent;
        return this;
    }

    public String toString() {
        return decorated.getTextNormalize();
    }
}
