package javaxml3;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.Format;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class Dom4jXMLProperties extends Properties {
    
    private DocumentFactory factory;

    public Dom4jXMLProperties() {
        this(new DocumentFactory());
    }
    
    public Dom4jXMLProperties(Properties defaults) {
        this(new DocumentFactory(), defaults);
        }
    
    public Dom4jXMLProperties(DocumentFactory factory) {
        this(factory, null);
    }
    
    public Dom4jXMLProperties(DocumentFactory factory, Properties defaults) {
        super(defaults);
        this.factory= factory;        
    }

    public void load(Reader reader) throws IOException {
        try {
            // adowanie XML do obiektu Document dom4j.
            SAXReader saxReader = new SAXReader(factory);
            Document doc = saxReader.read(reader);

            // Zamiana na obiekty waciwoci.
            loadFromElements(doc.getRootElement().elements(), new StringBuffer(
                    ""));
        } catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void loadFromElements(List elements, StringBuffer baseName) {
        // Przejcie przez kady element.
        for (Iterator i = elements.iterator(); i.hasNext();) {
            Element current = (Element) i.next();
            String name = current.getName();
            String text = current.getTextTrim();

            // Nie dodawaj "." jeli nie ma baseName.
            if (baseName.length() > 0) {
                baseName.append(".");
            }
            baseName.append(name);

			// Sprawdzanie czy mamy warto elementu.
            if ((text == null) || (text.equals(""))) {
				// Jeli nie ma tekstu to rekurencja na potomkw.
                loadFromElements(current.elements(), baseName);
            } else {
				// Jeli tekst, to jest to waciwo.
                setProperty(baseName.toString(), text);
            }

			// Przy wychodzeniu z rekurencji usu ostatni nazw.
            if (baseName.length() == name.length()) {
                baseName.setLength(0);
            } else {
                baseName.setLength(baseName.length() - (name.length() + 1));
            }
        }
    }

    public void load(InputStream inputStream) throws IOException {

        load(new InputStreamReader(inputStream));
    }

    public void load(File xmlDocument) throws IOException {

        load(new FileReader(xmlDocument));
    }

    public void save(OutputStream out, String header) {
        try {
            store(out, header);
        } catch (IOException ignored) {
			// Odradzana wersja nie informuje o bdach.
        }
    }

    public void store(Writer writer, String header) throws IOException {

        // Utworzenie nowego obiektu JDOM Document z elementem korzenia properties.
        Document doc = factory.createDocument();
        Element root = doc.addElement("properties");

        // Dodanie informacji nagwka.
        Comment comment = factory.createComment(header);
        doc.content().add(0, comment);

        // Pozyskanie nazw waciwoci.
        Enumeration propertyNames = propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String) propertyNames.nextElement();
            String propertyValue = getProperty(propertyName);
            createXMLRepresentation(root, propertyName, propertyValue);
        }

        // Zapisanie dokumentu w pliku o podanej nazwie.
        XMLWriter xmlWriter = new XMLWriter(writer);
        xmlWriter.write(doc);
        xmlWriter.close();
    }

    private void createXMLRepresentation(Element root, String propertyName,
            String propertyValue) {

        int split;
        String name = propertyName;
        Element current = root;
        Element test = null;

        while ((split = name.indexOf(".")) != -1) {
            String subName = name.substring(0, split);
            name = name.substring(split + 1);

			// Sprawdzanie czy element istnieje. 
            if ((test = current.element(subName)) == null) {
                Element subElement = current.addElement(subName);                
                current = subElement;
            } else {
                current = test;
            }
        }

		// Kiedy poza ptl, to co zostao jest ostateczn nazw elementu.
        Element last = factory.createElement(name);
        last.setText(propertyValue);
		/** Usu ten komentarz, aby zastosowa atrybuty. */
		/*
		last.setAttribute("value", propertyValue);
		*/

        current.add(last);
    }

    public void store(OutputStream out, String header) throws IOException {

        store(new OutputStreamWriter(out), header);
    }

    public void store(File xmlDocument, String header) throws IOException {

        store(new FileWriter(xmlDocument), header);
    }
}
