package javaxml3;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.DateFormat;
import java.util.Date;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class DateTimeSocketServer extends Thread {

    private Document currentDocument;

    private Element dateElement;

    private DateFormat dateFormat = DateFormat.getDateInstance(DateFormat.LONG);

    private XMLOutputter outputter;

    private int port;

    private Element timeElement;

    private DateFormat timeFormat = DateFormat.getTimeInstance(DateFormat.LONG);

    public DateTimeSocketServer(int port) {
        this.port = port;
        outputter = new XMLOutputter();
        currentDocument = new Document();
        Element root = new Element("current");
        currentDocument.setRootElement(root);
        dateElement = new Element("date");
        root.addContent(dateElement);
        timeElement = new Element("time");
        root.addContent(timeElement);
    }

    public void run() {
        try {
            ServerSocket server = new ServerSocket(port);
            System.out.println("Nasuchiwanie pocze na porcie "
                    + server.getLocalPort());

            while (true) {
                try {
                    Socket socket = server.accept();

                    BufferedWriter out = new BufferedWriter(
                            new OutputStreamWriter(socket.getOutputStream()));
                    while (!socket.isClosed()) {
                        String current = updateCurrentXML();
                        System.out.println("Wysyanie XML.");
                        out.write(current);
						// Na kocu musi by bajt zerowy, aby Flash wiedzia, e dokument
						// ju si skoczy.
                        out.write(0);
                        out.flush();

                        try {
                            Thread.sleep(1000);
                        } catch (InterruptedException e) {
                        }
                    }
                } catch (IOException e) {
					System.err.println("Wystpi wyjtek podczas przyjmowania: "
                            + e.getMessage());
                }
            }

        } catch (BindException e) {
			System.err.println("Nie mona uruchomi serwera. Port jest zajty.");
        } catch (IOException e) {
            System.err.println(e.getMessage());
        }

    }

    private String updateCurrentXML() {
        Date date = new Date();
        dateElement.setText(dateFormat.format(date));
        timeElement.setText(timeFormat.format(date));
        return outputter.outputString(currentDocument);
    }

    public static void main(String[] args) {
        int port;
        try {
            port = Integer.parseInt(args[0]);
        } catch (Exception ex) {
            port = 8900;
        }

        Thread t = new DateTimeSocketServer(port);
        t.start();
    }

}
