/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.VerifierFactory;
import org.apache.bcel.verifier.statics.Pass1Verifier;
import org.apache.bcel.verifier.statics.Pass2Verifier;
import org.apache.bcel.verifier.statics.Pass3aVerifier;
import org.apache.bcel.verifier.structurals.Pass3bVerifier;

public class Verifier {
    private final String classname;
    private Pass1Verifier p1v;
    private Pass2Verifier p2v;
    private Map<String, Pass3aVerifier> p3avs = new HashMap<String, Pass3aVerifier>();
    private Map<String, Pass3bVerifier> p3bvs = new HashMap<String, Pass3bVerifier>();

    public VerificationResult doPass1() {
        if (this.p1v == null) {
            this.p1v = new Pass1Verifier(this);
        }
        return this.p1v.verify();
    }

    public VerificationResult doPass2() {
        if (this.p2v == null) {
            this.p2v = new Pass2Verifier(this);
        }
        return this.p2v.verify();
    }

    public VerificationResult doPass3a(int method_no) {
        String key = Integer.toString(method_no);
        Pass3aVerifier p3av = this.p3avs.get(key);
        if (this.p3avs.get(key) == null) {
            p3av = new Pass3aVerifier(this, method_no);
            this.p3avs.put(key, p3av);
        }
        return p3av.verify();
    }

    public VerificationResult doPass3b(int method_no) {
        String key = Integer.toString(method_no);
        Pass3bVerifier p3bv = this.p3bvs.get(key);
        if (this.p3bvs.get(key) == null) {
            p3bv = new Pass3bVerifier(this, method_no);
            this.p3bvs.put(key, p3bv);
        }
        return p3bv.verify();
    }

    Verifier(String fully_qualified_classname) {
        this.classname = fully_qualified_classname;
        this.flush();
    }

    public final String getClassName() {
        return this.classname;
    }

    public void flush() {
        this.p1v = null;
        this.p2v = null;
        this.p3avs.clear();
        this.p3bvs.clear();
    }

    public String[] getMessages() throws ClassNotFoundException {
        int i;
        int meth;
        int i2;
        ArrayList<String> messages = new ArrayList<String>();
        if (this.p1v != null) {
            String[] p1m = this.p1v.getMessages();
            for (i2 = 0; i2 < p1m.length; ++i2) {
                messages.add("Pass 1: " + p1m[i2]);
            }
        }
        if (this.p2v != null) {
            String[] p2m = this.p2v.getMessages();
            for (i2 = 0; i2 < p2m.length; ++i2) {
                messages.add("Pass 2: " + p2m[i2]);
            }
        }
        for (Pass3aVerifier pv : this.p3avs.values()) {
            String[] p3am = pv.getMessages();
            meth = pv.getMethodNo();
            for (i = 0; i < p3am.length; ++i) {
                messages.add("Pass 3a, method " + meth + " ('" + Repository.lookupClass(this.classname).getMethods()[meth] + "'): " + p3am[i]);
            }
        }
        for (Pass3bVerifier pv : this.p3bvs.values()) {
            String[] p3bm = pv.getMessages();
            meth = pv.getMethodNo();
            for (i = 0; i < p3bm.length; ++i) {
                messages.add("Pass 3b, method " + meth + " ('" + Repository.lookupClass(this.classname).getMethods()[meth] + "'): " + p3bm[i]);
            }
        }
        String[] ret = new String[messages.size()];
        for (i2 = 0; i2 < messages.size(); ++i2) {
            ret[i2] = (String)messages.get(i2);
        }
        return ret;
    }

    public static void main(String[] args) {
        System.out.println("JustIce by Enver Haase, (C) 2001-2002.\n<http://bcel.sourceforge.net>\n<http://jakarta.apache.org/bcel>\n");
        for (int k = 0; k < args.length; ++k) {
            try {
                int dotclasspos;
                if (args[k].endsWith(".class") && (dotclasspos = args[k].lastIndexOf(".class")) != -1) {
                    args[k] = args[k].substring(0, dotclasspos);
                }
                args[k] = args[k].replace('/', '.');
                System.out.println("Now verifying: " + args[k] + "\n");
                Verifier v = VerifierFactory.getVerifier(args[k]);
                VerificationResult vr = v.doPass1();
                System.out.println("Pass 1:\n" + vr);
                vr = v.doPass2();
                System.out.println("Pass 2:\n" + vr);
                if (vr == VerificationResult.VR_OK) {
                    JavaClass jc = Repository.lookupClass(args[k]);
                    for (int i = 0; i < jc.getMethods().length; ++i) {
                        vr = v.doPass3a(i);
                        System.out.println("Pass 3a, method number " + i + " ['" + jc.getMethods()[i] + "']:\n" + vr);
                        vr = v.doPass3b(i);
                        System.out.println("Pass 3b, method number " + i + " ['" + jc.getMethods()[i] + "']:\n" + vr);
                    }
                }
                System.out.println("Warnings:");
                String[] warnings = v.getMessages();
                if (warnings.length == 0) {
                    System.out.println("<none>");
                }
                for (int j = 0; j < warnings.length; ++j) {
                    System.out.println(warnings[j]);
                }
                System.out.println("\n");
                v.flush();
                Repository.clearCache();
                System.gc();
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

