/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.DoubleArrayEditorPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyEditorSupport;

public class DoubleArrayEditor
extends PropertyEditorSupport {
    @Override
    public void setValue(Object value) {
        super.setValue(value);
    }

    @Override
    public Component getCustomEditor() {
        return new DoubleArrayEditorPanel(this);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void paintValue(Graphics g, Rectangle box) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        double[] values = (double[])this.getValue();
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < 3) {
            if (values.length > i) {
                s.append(values[i]);
            }
            if (values.length > i + 1) {
                s.append(", ");
            }
            ++i;
        }
        if (values.length > 3) {
            s.append("...");
        }
        g2.setPaint(Color.white);
        g2.fill(box);
        g2.setPaint(Color.black);
        FontRenderContext context = g2.getFontRenderContext();
        Rectangle2D stringBounds = g2.getFont().getStringBounds(s.toString(), context);
        double w = stringBounds.getWidth();
        double x = box.x;
        if (w < (double)box.width) {
            x += ((double)box.width - w) / 2.0;
        }
        double ascent = -stringBounds.getY();
        double y = (double)box.y + ((double)box.height - stringBounds.getHeight()) / 2.0 + ascent;
        g2.drawString(s.toString(), (float)x, (float)y);
    }

    @Override
    public String getJavaInitializationString() {
        double[] values = (double[])this.getValue();
        StringBuilder s = new StringBuilder();
        s.append("new double[] {");
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(values[i]);
            ++i;
        }
        s.append("}");
        return s.toString();
    }
}

