/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.PUSH;

public class EntryLogger {
    private ClassGen cg;
    private ConstantPoolGen cpg;

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                System.out.println("USAGE: java EntryLogger classname");
            } else {
                JavaClass javaClass = Repository.lookupClass((String)stringArray[0]);
                ClassGen classGen = new ClassGen(javaClass);
                EntryLogger entryLogger = new EntryLogger(classGen);
                entryLogger.convert();
                File file = new File(Repository.lookupClassFile((String)classGen.getClassName()).getPath());
                classGen.getJavaClass().dump(file.getPath());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public EntryLogger(ClassGen classGen) {
        this.cg = classGen;
        this.cpg = classGen.getConstantPool();
    }

    public void convert() throws IOException {
        for (Method method : this.cg.getMethods()) {
            AnnotationEntry[] annotationEntryArray;
            for (AnnotationEntry annotationEntry : annotationEntryArray = method.getAnnotationEntries()) {
                if (!annotationEntry.getAnnotationType().equals("LLogEntry;")) continue;
                for (ElementValuePair elementValuePair : annotationEntry.getElementValuePairs()) {
                    if (!elementValuePair.getNameString().equals("logger")) continue;
                    String string = elementValuePair.getValue().stringifyValue();
                    this.cg.replaceMethod(method, this.insertLogEntry(method, string));
                }
            }
        }
    }

    private Method insertLogEntry(Method method, String string) {
        MethodGen methodGen = new MethodGen(method, this.cg.getClassName(), this.cpg);
        String string2 = this.cg.getClassName();
        String string3 = methodGen.getMethod().getName();
        System.out.printf("Adding logging instructions to %s.%s%n", string2, string3);
        int n = this.cpg.addMethodref("java.util.logging.Logger", "getLogger", "(Ljava/lang/String;)Ljava/util/logging/Logger;");
        int n2 = this.cpg.addMethodref("java.util.logging.Logger", "entering", "(Ljava/lang/String;Ljava/lang/String;)V");
        InstructionList instructionList = methodGen.getInstructionList();
        InstructionList instructionList2 = new InstructionList();
        instructionList2.append((CompoundInstruction)new PUSH(this.cpg, string));
        instructionList2.append((Instruction)new INVOKESTATIC(n));
        instructionList2.append((CompoundInstruction)new PUSH(this.cpg, string2));
        instructionList2.append((CompoundInstruction)new PUSH(this.cpg, string3));
        instructionList2.append((Instruction)new INVOKEVIRTUAL(n2));
        InstructionHandle[] instructionHandleArray = instructionList.getInstructionHandles();
        instructionList.insert(instructionHandleArray[0], instructionList2);
        methodGen.setMaxStack();
        return methodGen.getMethod();
    }
}

