/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.corejava;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FileNameBean
extends JPanel {
    private static final int XPREFSIZE = 200;
    private static final int YPREFSIZE = 20;
    private JButton dialogButton;
    private JTextField nameField;
    private JFileChooser chooser;
    private String[] extensions = new String[]{"gif", "png"};

    public FileNameBean() {
        this.dialogButton = new JButton("...");
        this.nameField = new JTextField(30);
        this.chooser = new JFileChooser();
        this.setPreferredSize(new Dimension(200, 20));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        this.add((Component)this.nameField, gbc);
        this.dialogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileNameBean.this.chooser.setFileFilter(new FileNameExtensionFilter(Arrays.toString(FileNameBean.this.extensions), FileNameBean.this.extensions));
                int r = FileNameBean.this.chooser.showOpenDialog(null);
                if (r == 0) {
                    File f = FileNameBean.this.chooser.getSelectedFile();
                    String name = f.getAbsolutePath();
                    FileNameBean.this.setFileName(name);
                }
            }
        });
        this.nameField.setEditable(false);
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.gridx = 1;
        this.add((Component)this.dialogButton, gbc);
    }

    public void setFileName(String newValue) {
        String oldValue = this.nameField.getText();
        this.nameField.setText(newValue);
        this.firePropertyChange("fileName", oldValue, newValue);
    }

    public String getFileName() {
        return this.nameField.getText();
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String[] newValue) {
        this.extensions = newValue;
    }

    public String getExtensions(int i) {
        if (i >= 0 && i < this.extensions.length) {
            return this.extensions[i];
        }
        return "";
    }

    public void setExtensions(int i, String newValue) {
        if (i >= 0 && i < this.extensions.length) {
            this.extensions[i] = newValue;
        }
    }
}

