/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileReader;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class SimpleLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, ?> options;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("no handler");
        }
        NameCallback nameCall = new NameCallback("username: ");
        PasswordCallback passCall = new PasswordCallback("password: ", false);
        try {
            this.callbackHandler.handle(new Callback[]{nameCall, passCall});
        }
        catch (UnsupportedCallbackException e) {
            LoginException e2 = new LoginException("Unsupported callback");
            e2.initCause(e);
            throw e2;
        }
        catch (IOException e) {
            LoginException e2 = new LoginException("I/O exception in callback");
            e2.initCause(e);
            throw e2;
        }
        return this.checkLogin(nameCall.getName(), passCall.getPassword());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkLogin(String username, char[] password) throws LoginException {
        try {
            String[] inputs;
            Scanner in = new Scanner(new FileReader("" + this.options.get("pwfile")));
            do {
                if (in.hasNextLine()) continue;
                in.close();
                return false;
            } while (!(inputs = in.nextLine().split("\\|"))[0].equals(username) || !Arrays.equals(inputs[1].toCharArray(), password));
            String role = inputs[2];
            Set<Principal> principals = this.subject.getPrincipals();
            principals.add(new SimplePrincipal("username", username));
            principals.add(new SimplePrincipal("role", role));
            return true;
        }
        catch (IOException e) {
            LoginException e2 = new LoginException("Can't open password file");
            e2.initCause(e);
            throw e2;
        }
    }

    @Override
    public boolean logout() {
        return true;
    }

    @Override
    public boolean abort() {
        return true;
    }

    @Override
    public boolean commit() {
        return true;
    }
}

