/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValue;

public class ElementValuePair {
    private ElementValue elementValue;
    private ConstantPool constantPool;
    private int elementNameIndex;

    public ElementValuePair(int elementNameIndex, ElementValue elementValue, ConstantPool constantPool) {
        this.elementValue = elementValue;
        this.elementNameIndex = elementNameIndex;
        this.constantPool = constantPool;
    }

    public String getNameString() {
        ConstantUtf8 c = (ConstantUtf8)this.constantPool.getConstant(this.elementNameIndex, (byte)1);
        return c.getBytes();
    }

    public final ElementValue getValue() {
        return this.elementValue;
    }

    public int getNameIndex() {
        return this.elementNameIndex;
    }

    public String toShortString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getNameString()).append("=").append(this.getValue().toShortString());
        return result.toString();
    }

    protected void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.elementNameIndex);
        this.elementValue.dump(dos);
    }
}

