# Instalowanie Javy

Jeśli na soim komputerze jeszcze nie masz zainstalowanej Java&trade; Platform, Standard Edition Development Kit (JDK), to będziesz jej poprzebować. W niniejszej książce zakładamy, że używasz Javy 11 (za wyjątkiem zagadnień prezentowanych w Dodatku B, które wymagają użycia wersji Java 17). Jeśli zdarzy się, że używasz wersji Java 8, to większość przykładów prezentowanych w książce wciąż będzie działać. Jeśli nie wiesz, której wersji Javy użyć, to zalecamy Javę 17, która aktualnie jest wersją o długim okresie wsparcia (LTS - long time support; w notatce na końcu tego pliku znajdziesz dodatkowe informacje, które pozwolą Ci zrozumieć dlaczego wspominamy o tych trzech konkretnych wersjach Javy).

Istnieją także darmowe wersje [OpenJDK](https://openjdk.java.net/) (referencyjnej implementacji Javy) udostępniane przez kilku dostawców ([przeczytaj o nich więcej](https://medium.com/@javachampions/java-is-still-free-3-0-0-ocrt-2021-bca75c88d23b#04b1)). Dla uproszczenia wybraliśmy dwie z nich:

 - [Eclipse Adoptium](https://adoptium.net/): Darmowe wersja OpenJDK przygotowywane przez społeczność. Można tu znaleźć i pobrać Javę 8, 11 lub 17, czy też dowolną nowszą jeśli się pojawi, w wersjach na różne systemy operacyjne.
 - [Oracle](https://www.oracle.com/java/technologies/downloads/): Wielu programistów decyduje się pobierać JDK przygotowywane przez firmę Oracle; trzeba jednak pamiętać, że Oracle stosuje kilka różnych licencji, w tym także komercyjną, którą trzeba kupić. Jeśli [zdecydujesz się pobrać Javę 17](https://www.oracle.com/java/technologies/downloads/#jdk17-windows) z witryny Oracle, będzie to wersja "zapewniająca możliwość bezpłatnego wykorzystania w zastosowaniach produkcyjnych i bezpłatnej redystrybucji na zasadach licencji [Oracle No-Fee Terms and Conditions](https://www.oracle.com/downloads/licenses/no-fee-license.html)."

(Jeśli chesz dowiedzieć się więcej na temat tego, których wersji Javy można używać za darmo, oraz co oznacza, że są one "darmowe"means, przejrzyj dokument [Java is Still Free (3.0.0)](https://medium.com/@javachampions/java-is-still-free-3-0-0-ocrt-2021-bca75c88d23b) opracowany przez [Java Champions](https://dev.java/community/jcs/).) 

JDK zawiera wszystko czego potrzeba do kompilowania i uruchamiania programów pisanych w Javie. JDK nie zawiera jednak dokumentacji API, a jej bezwzględnie będziesz potrzebował! Możesz ją pobrać ze strony [Java SE API documentation](https://www.oracle.com/java/technologies/javase-jdk17-doc-downloads.html). Dokumentację API można także przeglądać na internecie, bez jej przeglądania - znajdziesz ją na stronie [API docs online](https://docs.oracle.com/en/java/javase/17/). Ale uwierz nam, naprawdę warto ją pobrać!

Do pisania programów będziesz także potrzebował edytora tekstów. Nada się do tego praktycznie każdy edytor (choćby vi lub emacs), w tym także edytory z graficznym interfejsem użytkownika domyślnie dostępne w większości systemów operacynych. No pracy nadadzą się takie edytor jak Notatnik, Wordpad, TextEdit, itd., o ile tylko będesz zapisywać je zapisywać jako *zwyczajny tekst* a nie *tekst sformatowany*, a na końcu plików nie będziesz dodawać rozszerzenia *.txt*, tylko *.java*.

Po pobraniu i zainstalowaniu (lub rozpakowaniu Javy - zależnie do używanego systemu operacyjnego), będziesz musiał dodać do zmiennej środowiskowej PATH ścieżkę dostępu do podkatalogu /bin katalogu w którym zainstalowałeś Javę. Dodanie ścieżki dostępu do tego katalogu do zmiennej środowiskowej PATH pozwoli Ci na wykonywanie polecania (w oknie wiersza poleceń, czy też terminala):

```
% javac
```
a system będzie w stanie odnaleźć i uruchomić kompilator Javy.

Uwaga: Jeśli napotkasz jakieś problemy podczas instalowania Javy sugerujemy, żebyś dołączył do jakiegoś forum dyskusyjnego dla użytkowników Javy i poszukał w nim sekcji dla początkujących. W zasadzie warto to zrobić nawet jeśli nie napotkasz żadnych problemów z instalacją Javy. Jednym z przykładów takich forów może być witryna [javaranch.com](https://javaranch.com/).

### Uwaga odnośnie numerów wersji

Numery wersji Javy zmieniły się znacząco w ciągu ponad 25 lat istnienia języka! Oczywiście wszystko zaczęło się od werji Java 1.0, po które pojawiły się kolejne: Java 1.1, 1.2, 1.3 oraz 1.4. Jednak później, z zadziwiających i niejasnych powodów marketingowych firma Sun zmieniła numer kolejnej wersji języka z Java 1.5 na Java 5, choć z technicznego punktu widzenia wciąż była to werjsa jedynie 1.5. To samo dotyczyło wersji 6 (1.6), 7 (1.7) oraz 8 (1.8).

Teoretycznie wciąż mamy do czynienia z językiem Java w wersji 1.x, gdyż kolejne wersje Javy są zgodne wstecz z wersją 1.0. Jednak podawanie oficjalnego numeru wersji innego niż ten standardowo używany przez wszystkich było dość mylące, dlatego zaczynając do Java 9 oficjalnym jest tylko numer końcowy, bez poprzedzającej go "1"; na przykład: Java 9 faktycznie jest wersją 9, a nie 1.9. Co więcej, zaczynając od Java 9, nowe wersje języka są udostępniane co 6 miesięcy (a nie jak było wcześniej co, mniej więcej, 3 lata); dlatego też numery zaczęły rosnąć bardzo szybko!

Jednak przy dwóch wesjach Javy udostępnianych każdego roku nie wszystkie firmy chcą aktualizowąć swoje środowiska robocze za każdym razem gdy pojawi się nowa wersa języka. To samo dotyczy producentów, którzy na pewno niechętnie podchodzą do utrzymywania dziesiątek wersji swoich produktów. Dlatego też powstała koncepcja wersji o długim okresie wsparcka - [Long Term Support release](https://www.oracle.com/java/technologies/java-se-support-roadmap.html). (Na pomysł ten wpadła firma Oracle, lecz został on wykorzystany przez wiele innych dostawców oprogramowania.) Aktualnie dostępne są trzy wersje LTS Javy: pierwszą z nich była Java 8, kolejną Java 11, a najnowszą jest Java 17. To właśnie z tego względu, pisząc o wersjach Javy których zastosowanie warto rozważać, wspominamy tylko o tych trzech. Oczywiście możesz używać dowolnej wersji języka, jednak w ramach ułatwienia, zazwyczaj wspomina się jedynie wersje LTS.