package rozdzial18.monikairobert;


import java.util.concurrent.*;
import java.util.concurrent.atomic.AtomicInteger;

public class MonikaIRobertAtomowiTest {
  public static void main(String[] args) throws InterruptedException {
    for (int i = 0; i < 100; i++) {
      KontoBankoweAtomowe konto = new KontoBankoweAtomowe();
      MonikaIRobertAtomowi robert = new MonikaIRobertAtomowi("Robert", konto, 50);
      MonikaIRobertAtomowi monika = new MonikaIRobertAtomowi("Monika", konto, 100);
      ExecutorService wykonawca = Executors.newFixedThreadPool(2);
      wykonawca.execute(robert);
      wykonawca.execute(monika);
      wykonawca.shutdown();
      wykonawca.awaitTermination(1, TimeUnit.MINUTES);
      System.out.println("---");
    }
  }
}

class MonikaIRobertAtomowi implements Runnable {
  private final String imie;
  private final KontoBankoweAtomowe konto;
  private final int kwotaDoWydania;

  MonikaIRobertAtomowi(String imie, KontoBankoweAtomowe konto, int kwotaDoWydania) {
    this.imie = imie;
    this.konto = konto;
    this.kwotaDoWydania = kwotaDoWydania;
  }

  public void run() {
    zrobZakupy(kwotaDoWydania);
  }

  private void zrobZakupy(int kwota) {
    System.out.println(imie + " zamierza wydać trochę pieniędzy.");
    konto.wydaj(imie, kwota);
    System.out.println(imie + " kończy zakupy.");
  }
}

class KontoBankoweAtomowe {
  private final AtomicInteger stanKonta = new AtomicInteger(100);

  public int pobierzStan() {
    return stanKonta.get();
  }
  
  public void wydaj(String imie, int kwota) {
    int stanPoczatkowy = stanKonta.get();
    if (stanPoczatkowy >= kwota) {
      boolean operacjaOk = stanKonta.compareAndSet(stanPoczatkowy, stanPoczatkowy - kwota);
      if (!operacjaOk) {
        System.out.println("Przykro mi " + imie + ", nie udało Ci się wydać pieniędzy.");
      }
    } else {
      System.out.println("Przykro mi, nie masz tylu pieniędzy, " + imie + ".");
    }
  }
}