package rozdzial12;


import java.util.List;
import java.util.Optional;

public class ZagadkaNaPiecMinut {
  public static void main(String[] args) {
    List<Kawa> kawy = List.of(new Kawa("Cappuccino", 3),
            new Kawa("Americano", 2), new Kawa("Espresso", 5),
            new Kawa("Cortado", 4), new Kawa("Mocha", 3),
            new Kawa("Flat White", 4), new Kawa("Latte", 3),
            new Kawa("Bezkofeinowe Cappuccino", 1));

    Optional<String> popoludniowaKawka = kawy.stream()
                                              .map(Kawa::getNazwa)
                                              .sorted()
                                              .findFirst();
    System.out.println(popoludniowaKawka);
    Optional<String> slabaKawa = kawy.stream()
                                     .sorted()
                                     .map(Kawa::getNazwa)
                                     .findFirst();
    System.out.println(slabaKawa);

  }

  private static class Kawa implements Comparable<Kawa>{
    private final String nazwa;
    private final int moc;

    public Kawa(String nazwa, int moc) {
      this.nazwa = nazwa;
      this.moc = moc;
    }

    public String getNazwa() {
      return nazwa;
    }

    public int getMoc() {
      return moc;
    }

    @Override
    public int compareTo(Kawa other) {
      return this.moc - other.moc;
    }
  }
}
