package rozdzial12;

import java.util.*;
import java.util.stream.*;
import java.util.function.*;

public class DodatkowePrzykladyStrumieni {
  public static void main(String[] args) {
    zliczanieArtystow();
    //wykonawcyUtworuZPominieciemTworcy();
  } 
  
  
  protected static void wykonawcyUtworuZPominieciemTworcy() {
    List<Piosenka> piosenki = new DaneSzafyGrajacej.Piosenki().pobierzPiosenki();
    
    String tytulUtworu = "With a Little Help from My Friends";
    List<String> gatunki = piosenki.stream()
                                   .filter(song -> song.getTytul().equals(tytulUtworu))
                                   .map(piosenka -> piosenka.getArtysta())
                                   .filter(artysta -> !artysta.equals("The Beatles"))
                                   .collect(Collectors.toList());
    System.out.println(gatunki);    
  }

  protected static void sortowanieOdNajstarszejDoNajnowszej() {
    List<Piosenka> piosenki = new DaneSzafyGrajacej.Piosenki().pobierzPiosenki();
    
    List<Piosenka> wyniki = piosenki.stream()
                                    .sorted((o1, o2) -> o1.getRok() - o2.getRok())
                                    .collect(Collectors.toList());
    
    System.out.println(wyniki);    
    
    Function<Piosenka, String> getGatunek = piosenka -> piosenka.getGatunek();
    Function<Piosenka, Integer> getRok = piosenka -> piosenka.getRok();

    List<Piosenka> wyniki2 = piosenki.stream()
                                     .sorted(Comparator.comparingInt(Piosenka::getRok))
                                     .collect(Collectors.toList());
    
    System.out.println(wyniki2);
  }
  
  
  protected static void kolektorToSet() {
    List<Piosenka> piosenki = new DaneSzafyGrajacej.Piosenki().pobierzPiosenki();
    
    Set<String> gatunki = piosenki.stream()
                                  .map(song -> song.getGatunek())
                                  .collect(Collectors.toSet());     
                                  
                                  
    System.out.println(gatunki);
  }

  
  protected static void jakiesUtworyRaB() {
    List<Piosenka> piosenki = new DaneSzafyGrajacej.Piosenki().pobierzPiosenki();
    
    boolean wynik = piosenki.stream()
                            .anyMatch(p -> p.getGatunek().equals("R&B"));
                                  
    System.out.println(wynik);
  }
  
  
  protected static void pierwszyDebiutZ1995() {
    List<Piosenka> piosenki = new DaneSzafyGrajacej.Piosenki().pobierzPiosenki();
    
    Optional<Piosenka> wynik = piosenki.stream()
                                       .filter( p -> p.getRok() == 1995 )
                                       .findFirst();
                                  
    System.out.println(wynik);
  }

  
  protected static void zliczanieArtystow() {
    List<Piosenka> piosenki = new DaneSzafyGrajacej.Piosenki().pobierzPiosenki();
    
    long wynik = piosenki.stream()
                         .map( p -> p.getArtysta())
                         .distinct()
                         .count();
                                  
    System.out.println(wynik);
  }
  
}

