package dodatekB.stary;

import java.util.Objects;

public class Klient {
  private final int id;
  private final String nazwa;

  public Klient(int id, String nazwa) {
    this.id = id;
    this.nazwa = nazwa;
  }

  public int getId() {
    return id;
  }

  public String getNazwa() {
    return nazwa;
  }

  @Override
  public boolean equals(Object obj) {
    if (obj == this) {
      return true;
    }
    if (obj == null || obj.getClass() != this.getClass()) {
      return false;
    }
    var inny = (Klient) obj;
    return this.id == inny.id &&
           Objects.equals(this.nazwa, inny.nazwa);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, nazwa);
  }

  @Override
  public String toString() {
    return "Klient{" +
           "id=" + id +
           ", nazwa='" + nazwa + '\'' +
           '}';
  }
}
