package rozdzial18.cwiczenie;



import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class SynchronizowaneKolekcje {
  //13 959 ms
  public static void main(String[] args) throws InterruptedException {
    ExecutorService pulaWatkow = Executors.newFixedThreadPool(2);
    long start = System.currentTimeMillis();
    for (int i = 0; i < 10; i++) {
      IDane dane = new DaneSynchronizowane();
      pulaWatkow.execute(new DodajZadanieMalejLitery(dane));
      pulaWatkow.execute(new DodajZadanieDuzejLitery(dane));
    }
    pulaWatkow.shutdown();
    pulaWatkow.awaitTermination(5, TimeUnit.MINUTES);
    long koniec = System.currentTimeMillis();
    System.out.println("Całkowity czas: " + (koniec - start));
  }
}

class DaneSynchronizowane implements IDane {
  private final List<String> litery = new ArrayList<>();

  public List<String> getLitery() {
    return litery;
  }

  public synchronized void dodajLitere(char litera) {
    litery.add(String.valueOf(litera));
  }
}
