package rozdzial18;


import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.*;

import static java.time.format.DateTimeFormatter.ofLocalizedTime;
import static java.time.format.FormatStyle.MEDIUM;

public class WspolbiezniCzytelnicy {
  public static void main(String[] args) {
    //List<Pogawedka> historiaRozmowy = new ArrayList<>();
    List<Pogawedka> historiaRozmowy = new CopyOnWriteArrayList<>();
    ExecutorService wykonawca = Executors.newFixedThreadPool(3);
    for (int i = 0; i < 5; i++) {
      wykonawca.execute(() -> historiaRozmowy.add(new Pogawedka("Siemka!")));
      wykonawca.execute(() -> System.out.println(historiaRozmowy));
      wykonawca.execute(() -> System.out.println(historiaRozmowy));
    }
    wykonawca.shutdown();
  }
}

final class Pogawedka {
  private final String komunikat;
  private final LocalDateTime znacznikCzasu;

  public Pogawedka(String komunikat) {
    this.komunikat = komunikat;
    znacznikCzasu = LocalDateTime.now();
  }

  public String toString() {
    String czas = znacznikCzasu.format(ofLocalizedTime(MEDIUM));
    return czas + " " + komunikat;
  }
}
