package rozdzial18.cwiczenie;


import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class BezpiecznaKolekcja {
  // 13920 ms
  public static void main(String[] args) throws InterruptedException {
    ExecutorService pulaWatkow = Executors.newFixedThreadPool(2);
    long start = System.currentTimeMillis();
    for (int i = 0; i < 10; i++) {
      IDane data = new SejfDanych();
      pulaWatkow.execute(new DodajZadanieDuzejLitery(data));
      pulaWatkow.execute(new DodajZadanieMalejLitery(data));
    }
    pulaWatkow.shutdown();
    pulaWatkow.awaitTermination(5, TimeUnit.MINUTES);
    long koniec = System.currentTimeMillis();
    System.out.println("Całkowity czas: " + (koniec - start));
  }
}

class SejfDanych implements IDane {
  private final List<String> litery = new CopyOnWriteArrayList<>();

  public List<String> getLitery() {
    return litery;
  }

  public void dodajLitere(char litera) {
    litery.add(String.valueOf(litera));
  }
}

