//package dodatekA;

import javax.sound.midi.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.Socket;
import java.util.*;
import java.util.List;
import java.util.concurrent.*;

public class AlternatywnaMuzMachina {
  private static final int LICZBA_BITOW = 16;
  private final List<BitInstrument> instrumenty;

  private final Map<BitInstrument, List<JCheckBox>> polaWyboruInstrumentow = new TreeMap<>();
  private JList<String> wiadomosci;
  private JTextField tekstWiadomosci;

  private int nastepnyNum;
  private String uzytkownik;
  private final Vector<String> odebraneWiadomosci = new Vector<>();
  private ObjectOutputStream wyj;
  private ObjectInputStream wej;
  private final HashMap<String, boolean[]> mapaOdebranychKompozycji = new HashMap<>();

  private Sequencer sekwenser;
  private Sequence sekwencja;
  private Track sciezka;

  public static void main(String[] args) {
    new AlternatywnaMuzMachina().inicjalizacjaAplikacji(args[0]);  // args[0] is your user ID/screen name
  }

  public AlternatywnaMuzMachina() {
    instrumenty = List.of(
            new BitInstrument("Bass Drum", 35),
            new BitInstrument("Closed Hi-Hat", 42),
            new BitInstrument("Open Hi-Hat", 46),
            new BitInstrument("Acoustic Snare", 38),
            new BitInstrument("Crash Cymbal", 49),
            new BitInstrument("Hand Clap", 39),
            new BitInstrument("High Tom", 50),
            new BitInstrument("Hi Bongo", 60),
            new BitInstrument("Maracas", 70),
            new BitInstrument("Whistle", 72),
            new BitInstrument("Low Conga", 64),
            new BitInstrument("Cowbell", 56),
            new BitInstrument("Vibraslap", 58),
            new BitInstrument("Low-mid Tom", 47),
            new BitInstrument("High Agogo", 67),
            new BitInstrument("Open Hi Conga", 63));
  }

  public void inicjalizacjaAplikacji(String imie) {
    uzytkownik = imie;
    try {
      Socket gniazdo = new Socket("127.0.0.1", 4242);
      wyj = new ObjectOutputStream(gniazdo.getOutputStream());
      wej = new ObjectInputStream(gniazdo.getInputStream());
      ExecutorService wykonawca = Executors.newSingleThreadExecutor();
      wykonawca.submit(new CzytelnikZdalnychDanych());
    } catch (IOException ex) {
      System.out.println("Nie można nawiązać połączenia - będziesz grał samemu.");
    }
    konfigurujMidi();
    tworzGUI();
  }

  public void tworzGUI() {
    JFrame ramkaGlowna = new JFrame("Cyber MuzMachina");
    BorderLayout uklad = new BorderLayout();
    JPanel tlo = new JPanel(uklad);
    tlo.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

    Box obszarPrzyciskow = new Box(BoxLayout.Y_AXIS);
    JButton start = new JButton("Start");
    start.addActionListener(e -> utworzSciezkeIOdtworz());
    obszarPrzyciskow.add(start);

    JButton stop = new JButton("Stop");
    stop.addActionListener(e -> sekwenser.stop());
    obszarPrzyciskow.add(stop);

    JButton tempoSzb = new JButton("Szybciej");
    tempoSzb.addActionListener(e -> zmienTempo(1.03));
    obszarPrzyciskow.add(tempoSzb);

    JButton tempoWol = new JButton("Wolniej");
    tempoWol.addActionListener(e -> zmienTempo(0.97));
    obszarPrzyciskow.add(tempoWol);

    JButton wyslij = new JButton("Wyślij");
    wyslij.addActionListener(new WyslijOdbiorcaZd());
    obszarPrzyciskow.add(wyslij);

    tekstWiadomosci = new JTextField();

    obszarPrzyciskow.add(tekstWiadomosci);

    wiadomosci = new JList<>();
    wiadomosci.addListSelectionListener(new WyborZListyOdbiorcaZd());
    wiadomosci.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    obszarPrzyciskow.add(new JScrollPane(wiadomosci));
    wiadomosci.setListData(odebraneWiadomosci); // Początkowo brak danych

    Box obszarNazw = new Box(BoxLayout.Y_AXIS);
    GridLayout siatkaPolWyboru = new GridLayout(instrumenty.size(), LICZBA_BITOW, 2, 1);
    JPanel panelPolWyboru = new JPanel(siatkaPolWyboru);

    for (BitInstrument instrument : instrumenty) {
      JLabel instrumentName = new JLabel(instrument.getNazwaInstrumentu());
      instrumentName.setBorder(BorderFactory.createEmptyBorder(4, 1, 4, 1));
      obszarNazw.add(instrumentName);

      List<JCheckBox> listaPolWyboru = new ArrayList<>();
      for (int i = 0; i < LICZBA_BITOW; i++) {
        JCheckBox poleWyb = new JCheckBox();
        poleWyb.setSelected(false);
        listaPolWyboru.add(poleWyb);
        panelPolWyboru.add(poleWyb);
      }
      polaWyboruInstrumentow.put(instrument, listaPolWyboru);
    }

    tlo.add(BorderLayout.EAST, obszarPrzyciskow);
    tlo.add(BorderLayout.WEST, obszarNazw);
    tlo.add(BorderLayout.CENTER, panelPolWyboru);

    ramkaGlowna.getContentPane().add(tlo);
    ramkaGlowna.setBounds(50, 50, 300, 300);
    ramkaGlowna.pack();
    ramkaGlowna.setVisible(true);
  }

  public void konfigurujMidi() {
    try {
      sekwenser = MidiSystem.getSequencer();
      sekwenser.open();
      sekwencja = new Sequence(Sequence.PPQ, 4);
      sciezka = sekwencja.createTrack();
      sekwenser.setTempoInBPM(120);
    } catch (InvalidMidiDataException | MidiUnavailableException ex) {
      ex.printStackTrace();
    }
  }

  public void utworzSciezkeIOdtworz() {
    sekwencja.deleteTrack(sciezka);
    sciezka = sekwencja.createTrack();

    for (Map.Entry<BitInstrument, List<JCheckBox>> instrumentyNaBity : polaWyboruInstrumentow.entrySet()) {
      List<JCheckBox> polaWyboru = instrumentyNaBity.getValue();
      for (int i = 0; i < polaWyboru.size(); i++) {
        if (polaWyboru.get(i).isSelected()) {
          BitInstrument instrument = instrumentyNaBity.getKey();
          sciezka.add(tworzZdarzenie(ShortMessage.NOTE_ON, instrument.getWartoscMidi(), 100, i));
          sciezka.add(tworzZdarzenie(ShortMessage.NOTE_OFF, instrument.getWartoscMidi(), 100, i + 1));
        }
      }
    }
    sciezka.add(tworzZdarzenie(ShortMessage.PROGRAM_CHANGE, 1, 0, 15)); // - zawsze przechodzimy pełne 16 bitów
    try {
      sekwenser.setSequence(sekwencja);
      sekwenser.setLoopCount(sekwenser.LOOP_CONTINUOUSLY);
      sekwenser.start();
      sekwenser.setTempoInBPM(120);
    } catch (InvalidMidiDataException ex) {
      ex.printStackTrace();
    }
  }

  public class WyslijOdbiorcaZd implements ActionListener {
    public void actionPerformed(ActionEvent a) {
      // Tworzymy tablicę STANÓW pól wyboru
      boolean[] stanPolaWyboru = new boolean[256];

      int i = 0;
      for (List<JCheckBox> polaWyboruInstrumentow : polaWyboruInstrumentow.values()) {
        for (JCheckBox poleWyboruInstrumentu : polaWyboruInstrumentow) {
          stanPolaWyboru[i++] = poleWyboruInstrumentu.isSelected();
        }
      }
      try {
        wyj.writeObject(uzytkownik + nastepnyNum++ + ": " + tekstWiadomosci.getText());
        wyj.writeObject(stanPolaWyboru);
      } catch (IOException ex) {
        System.out.println("Bardzo mi przykro. Nie udało się wysłać danych na serwer.");
        ex.printStackTrace();
      }
      tekstWiadomosci.setText("");
    }
  }

  public class WyborZListyOdbiorcaZd implements ListSelectionListener {
    public void valueChanged(ListSelectionEvent le) {
      if (!le.getValueIsAdjusting()) {
        String wybrane = wiadomosci.getSelectedValue();
        if (wybrane != null) {
          // A teraz przechodzimy do mapy i zmieniamy sekwencję
          boolean[] stanZaznaczonych = mapaOdebranychKompozycji.get(wybrane);
          zmienSekwencje(stanZaznaczonych);
          sekwenser.stop();
          utworzSciezkeIOdtworz();
        }
      }
    }
  }

  public class CzytelnikZdalnychDanych implements Runnable {
    public void run() {
      try {
        Object obj;
        while ((obj = wej.readObject()) != null) {
          System.out.println("got an object from server");
          String imieDoWyswietlenia = (String) obj;
          boolean[] stanPolaWyboru = (boolean[]) wej.readObject();
          mapaOdebranychKompozycji.put(imieDoWyswietlenia, stanPolaWyboru);
          odebraneWiadomosci.add(imieDoWyswietlenia);
          wiadomosci.setListData(odebraneWiadomosci);
        }
      } catch (IOException | ClassNotFoundException ex) {
        ex.printStackTrace();
      }
    }
  }

  private void zmienSekwencje(boolean[] newCheckboxStates) {
    int i = 0;
    for (List<JCheckBox> poleWyboruInstrumentu : polaWyboruInstrumentow.values()) {
      for (JCheckBox poleWyboru : poleWyboruInstrumentu) {
        poleWyboru.setSelected(newCheckboxStates[i++]);
      }
    }
  }

  private MidiEvent tworzZdarzenie(int plc, int jeden, int dwa, int takt) {
    try {
      ShortMessage komunikatMidi = new ShortMessage(plc, 9, jeden, dwa);
      return new MidiEvent(komunikatMidi, takt);
    } catch (InvalidMidiDataException ignorowany) {
      return null;
    }
  }

  private void zmienTempo(double mnoznikTempa) {
    float wspolczynikTempa = sekwenser.getTempoFactor();
    sekwenser.setTempoFactor((float) (wspolczynikTempa * mnoznikTempa));
  }

  private static final class BitInstrument implements Comparable<BitInstrument> {
    private final String nazwaInstrumentu;
    private final int wartoscMidi;

    BitInstrument(String nazwa, int wartoscMidi) {
      this.nazwaInstrumentu = nazwa;
      this.wartoscMidi = wartoscMidi;
    }

    public String getNazwaInstrumentu() {
      return nazwaInstrumentu;
    }

    public int getWartoscMidi() {
      return wartoscMidi;
    }

    public int compareTo(BitInstrument inny) {
      return nazwaInstrumentu.compareTo(inny.nazwaInstrumentu);
    }
  }
}


        

             

          

          

          