package rozdzial17;

import java.io.*;
import java.net.InetSocketAddress;
import java.nio.channels.*;
import java.util.*;
import java.util.concurrent.*;

import static java.nio.charset.StandardCharsets.UTF_8;

public class ProstySerwerPogawedek {
  private final List<PrintWriter> piszarzeKlientow = new ArrayList<>();

  public static void main(String[] args) {
    new ProstySerwerPogawedek().doDziela();
  }

  public void doDziela() {
    ExecutorService polaWatkow = Executors.newCachedThreadPool();
    try {
      ServerSocketChannel kanalSerwera = ServerSocketChannel.open();
      kanalSerwera.bind(new InetSocketAddress(5000));

      while (kanalSerwera.isOpen()) {
        SocketChannel kanalKlienta = kanalSerwera.accept();
        PrintWriter pisarz = new PrintWriter(Channels.newWriter(kanalKlienta, UTF_8));
        piszarzeKlientow.add(pisarz);
        polaWatkow.submit(new ObslugaKlienta(kanalKlienta));
        System.out.println("Mamy połączenie");
      }
    } catch (IOException ex) {
      ex.printStackTrace();
    }
  }

  private void rozeslijDoWszystkich(String komunikat) {
    for (PrintWriter pisarz : piszarzeKlientow) {
      pisarz.println(komunikat);
      pisarz.flush();
    }
  }

  public class ObslugaKlienta implements Runnable {
    BufferedReader czytelnik;
    SocketChannel kanal;

    public ObslugaKlienta(SocketChannel kanalKlienta) {
      kanal = kanalKlienta;
      czytelnik = new BufferedReader(Channels.newReader(kanal, UTF_8));
    }

    public void run() {
      String wiadomosc;
      try {
        while ((wiadomosc = czytelnik.readLine()) != null) {
          System.out.println("odczytano " + wiadomosc);
          rozeslijDoWszystkich(wiadomosc);
        }
      } catch (IOException ex) {
        ex.printStackTrace();
      }
    }
  }
}