package rozdzial17;


import javax.swing.*;
import java.awt.*;
import java.io.*;
import java.net.InetSocketAddress;
import java.nio.channels.*;
import java.util.concurrent.*;

import static java.nio.charset.StandardCharsets.UTF_8;

public class ProstyKlientPogawedek {
  private JTextArea odebraneWiadomosci;
  private JTextField wiadomosc;
  private BufferedReader czytelnik;
  private PrintWriter pisarz;

  public void doDziela() {
    konfigurujKomunikacje();

    JScrollPane przewijanie = utworzPrzewijalnyObszarTekstowy();

    wiadomosc = new JTextField(20);

    JButton przyciskWyslij = new JButton("Wyślij");
    przyciskWyslij.addActionListener(e -> wyslijWiadomosc());

    JPanel panelGlowny = new JPanel();
    panelGlowny.add(przewijanie);
    panelGlowny.add(wiadomosc);
    panelGlowny.add(przyciskWyslij);

    ExecutorService wykonawca = Executors.newSingleThreadExecutor();
    wykonawca.execute(new OdbiorcaWiadomosci());

    JFrame ramka = new JFrame("Śmiesznie prosty klient pogawędek");
    ramka.getContentPane().add(BorderLayout.CENTER, panelGlowny);
    ramka.setSize(400, 350);
    ramka.setVisible(true);
    ramka.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
  }

  private JScrollPane utworzPrzewijalnyObszarTekstowy() {
    odebraneWiadomosci = new JTextArea(15, 30);
    odebraneWiadomosci.setLineWrap(true);
    odebraneWiadomosci.setWrapStyleWord(true);
    odebraneWiadomosci.setEditable(false);
    JScrollPane przewijanie = new JScrollPane(odebraneWiadomosci);
    przewijanie.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
    przewijanie.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
    return przewijanie;
  }

  private void konfigurujKomunikacje() {
    try {
      InetSocketAddress adresSerwera = new InetSocketAddress("127.0.0.1", 5000);
      SocketChannel kanalSC = SocketChannel.open(adresSerwera);

      czytelnik = new BufferedReader(Channels.newReader(kanalSC, UTF_8));
      pisarz = new PrintWriter(Channels.newWriter(kanalSC, UTF_8));

      System.out.println("Obsługa sieci skonfigurowana. Adres i port klienta: " + kanalSC.getLocalAddress());
    } catch (IOException ex) {
      ex.printStackTrace();
    }
  }

  private void wyslijWiadomosc() {
    pisarz.println(wiadomosc.getText());
    pisarz.flush();
    wiadomosc.setText("");
    wiadomosc.requestFocus();
  }

  public class OdbiorcaWiadomosci implements Runnable {
    public void run() {
      String wiadomosc;
      try {
        while ((wiadomosc = czytelnik.readLine()) != null) {
          System.out.println("odczyt " + wiadomosc);
          odebraneWiadomosci.append(wiadomosc + "\n");
        }
      } catch (IOException ex) {
        ex.printStackTrace();
      }
    }
  }

  public static void main(String[] args) {
    new ProstyKlientPogawedek().doDziela();
  }
}