package rozdzial16;


import java.io.*;
import java.util.List;

public class ZapiszZFinally {
  private List<KartaKwizowa> listaKart;

  private void zapiszPlik(File plik) {
    BufferedWriter pisarz = null;
    try {
      pisarz = new BufferedWriter(new FileWriter(plik));

      for (KartaKwizowa karta : listaKart) {
        pisarz.write(karta.getPytanie() + "/");
        pisarz.write(karta.getOdpowiedz() + "\n");
      }

    } catch (IOException ex) {
      System.out.println("Nie udało się zapisać pliku kart: " + ex.getMessage());
    } finally {
      try {
        pisarz.close();
      } catch (Exception ex) {
        System.out.println("Nie udało się zamknąć obiektu pisarza: " + ex.getMessage());
      }
    }
  }
}
