// Demonstruje prostą listę JList 
  
import javax.swing.*;  
import javax.swing.event.*; 
import java.awt.*; 
import java.awt.event.*; 
   
public class ListDemo implements ListSelectionListener {  
  
  JList<String> jlst; 
  JLabel jlab; 
  JScrollPane jscrlp; 
 
  // Tworzy tablicę imion 
  String[] names = { "Ewa", "Janina", "Robert",  
                     "Sandra", "Joanna",  "Rafał",
                     "Bolek", "Maria", "Krzysio", 
                     "Andrzej", "Maciej", "Tomek" }; 
 
  ListDemo() {  
    // Tworzy kontener JFrame 
    JFrame jfrm = new JFrame("Lista JList"); 
 
    // Wybiera FlowLayout jako menedżer układu 
    jfrm.setLayout(new FlowLayout());  
 
    // Nadaje oknu początkowe rozmiary 
    jfrm.setSize(200, 160); 
  
    // Aplikacja zakończy działanie na skutek zamknięcia okna 
    jfrm.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE); 
  
    // Tworzy listę JList 
    jlst = new JList<String>(names);
 
    // Określa tryb wyboru 
    jlst.setSelectionMode(ListSelectionModel.SINGLE_SELECTION); 

    // Opakowuje listę kontenerem JScrollPane 
    jscrlp = new JScrollPane(jlst);
 
    // Określa preferowany rozmiar kontenera przewijającego 
    jscrlp.setPreferredSize(new Dimension(120, 90)); 
 
    // Tworzy etykietę, która będzie wyświetlać tekst zachęty
    // lub wybrane imię 
    jlab = new JLabel("Wybierz imię"); 
 
    // Dodaje obiekt nasłuchujący zdarzeń listy 
    jlst.addListSelectionListener(this);
 
    // Umieszcza listę i etykietę w panelu zawartości 
    jfrm.add(jscrlp); 
    jfrm.add(jlab); 
  
    // Wyświetla okno 
    jfrm.setVisible(true); 
  }  

  // Obsługuje zdarzenia listy
  public void valueChanged(ListSelectionEvent le) {                  
    // Pobiera indeks elementu 
    int idx = jlst.getSelectedIndex();
 
    // Wyświetla imię, jeśli element został wybrany 
    if(idx != -1) 
      jlab.setText("Aktualny wybór: " + names[idx]); 
    else // W przeciwnym razie ponawia zachętę 
      jlab.setText("Wybierz imię"); 
  }  
 
  public static void main(String[] args) {  
    // Tworzy okno w wątku rozdziału zdarzeń 
    SwingUtilities.invokeLater(new Runnable() { 
      public void run() { 
        new ListDemo(); 
      } 
    }); 
  }  
}
