/* Wyświetla plik tekstowy 
 
   Uruchamiając ten program, podaj nazwę pliku,
   którego zawartość chcesz zobaczyć.
   Na przykład aby wyświetlić zawartość pliku TEST.TXT, 
   użyj poniższego wywołania. 
 
   java ShowFile TEST.TXT 
*/ 
 
import java.io.*; 
 
class ShowFile { 
  public static void main(String[] args)  
  { 
    int i; 
    FileInputStream fin; 
 
    // Upewnia się, że podano nazwę pliku
    if(args.length != 1) {
      System.out.println("Sposób użycia: ShowFile NazwaPliku"); 
      return;
    }

    try { 
      fin = new FileInputStream(args[0]); 
    } catch(FileNotFoundException exc) { 
      System.out.println("Plik nie został znaleziony."); 
      return; 
    }

    try { 
      // Wczytuje bajty, aż napotka koniec pliku 
      do { 
        i = fin.read();
        if(i != -1) System.out.print((char) i); 
      } while(i != -1);  
    } catch(IOException exc) {
      System.out.println("Błąd podczas odczytu pliku.");
    }

    try {
      fin.close(); 
    } catch(IOException exc) {
      System.out.println("Błąd podczas zamykania pliku.");
    }
  } 
}
