// Przedstawienie dwóch prostych wyrażeń lambda

// Interfejs funkcyjny
interface MyValue {
  double getValue();
}   

// Drugi interfejs funkcyjny
interface MyParamValue {
  double getValue(double v);
}

class LambdaDemo {
  public static void main(String[] args)
  {
    MyValue myVal; // Deklaruje referencję typu interfejsu
    // W tym przykładzie wyrażenie lambda zwraca wartość stałą
    // Po przypisaniu wyrażenia do zmiennej zostaje utworzona 
    // instancja klasy, w której wyrażenie lambda implementuje 
    // metodę getValue() interfejsu MyValue
    myVal = () -> 98.6; 

    // Wywołuje metodę getValue(), która jest określana przez
    // przypisane wcześniej wyrażenie lambda
    System.out.println("Wartość stała: " + myVal.getValue());

    // Tworzy wyrażenie lambda z parametrem i przypisuje
    // je zmiennej typu MyParamValue. To wyrażenie zwraca wartość
    // odwrotną przekazanego argumentu
    MyParamValue myPval = (n) -> 1.0 / n; 

    // Wywołuje getValue(v), używając referencji myPval
    System.out.println("Odwrotnością liczby 4 jest " + myPval.getValue(4.0));
    System.out.println("Odwrotnością liczby 8 jest " + myPval.getValue(8.0));
    // Wyrażenie lambda musi być zgodne z metodą zdefiniowaną 
    // w interfejsie funkcyjnym. Dlatego próba zastosowania poniższych
    // wyrażeń skończy się zgłoszeniem błędu:
// myVal = () -> "trzy"; // Błąd! Typ String nie jest zgodny z double!
// myPval = () -> Math.random(); // Błąd! Wymagany parametr!
  }
}
