/*
   Przykład 11.1

   Tworzenie klasy pochodnej klasy Thread
*/
class MyThread extends Thread {

  // Tworzy nowy wątek
  MyThread(String name) {
    super(name); // Nadaje nazwę wątku
  }

  // Rozpoczyna wykonywanie nowego wątku
  public void run() {
    System.out.println(getName() + " rozpoczyna działanie.");
    try {
      for(int count=0; count < 10; count++) {
        Thread.sleep(400);
        System.out.println(getName() +
                           " jest wykonywany, wartość licznika " + count);
      }
    }
    catch(InterruptedException exc) {
      System.out.println(getName() + " został przerwany.");
    }

    System.out.println(getName() + " kończy działanie.");
  }
}

class ExtendThread {
  public static void main(String[] args) {
    System.out.println("Główny wątek rozpoczyna działanie.");

    MyThread mt = new MyThread("Wątek potomny nr 1");

    mt.start();

    for(int i=0; i < 50; i++) {
      System.out.print(".");
      try {
        Thread.sleep(100);
      }
      catch(InterruptedException exc) {
        System.out.println("Wątek główny został przerwany.");
      }
    } 

    System.out.println("Wątek główny kończy działanie.");
  }
}
