// Zmiana instrukcji switch na wyrażenie switch 
class SwitchExprDemo {

  enum ShipMethod { STANDARD, TRUCK, AIR, OVERNIGHT }

  public static void main(String[] args) {

    int productID = 5099;

    // Oto wyrażenie switch. Wartości zwracane przez instrukcję yield w każdej
    // z klauzul case zostają zapisane w zmiennej shipBy
    ShipMethod shipBy = switch(productID) {
      case 1774, 8708, 6709:
        yield ShipMethod.TRUCK;
      case 4657, 2195, 1887, 3621:
        yield ShipMethod.AIR;
      case 2907, 5099: 
        yield ShipMethod.OVERNIGHT;
      default:
        yield ShipMethod.STANDARD;
    }; // Zwróć uwagę, że średnik w tym przypadku jest konieczny!

    System.out.println("Produkt o ID " + productID + " jest wysyłany metodą " 
                       + shipBy);
  }
}
