// Demonstruje priorytety wątków
 
class Priority implements Runnable { 
  int count; 
  Thread thrd; 
 
  static boolean stop = false; 
  static String currentName; 
 
  // Tworzy nowy wątek
  Priority(String name) { 
    thrd = new Thread(this, name); 
    count = 0; 
    currentName = name; 
  } 
 
  // Rozpoczyna wykonywanie nowego wątku
  public void run() { 
    System.out.println(thrd.getName() + " rozpoczyna działanie."); 
    do { 
      count++; 
 
      if(currentName.compareTo(thrd.getName()) != 0) { 
        currentName = thrd.getName(); 
        System.out.println(currentName + " jest wykonywany."); 
      } 
 
    } while(stop == false && count < 10000000);  
    stop = true; 
 
    System.out.println("\n" + thrd.getName() + 
                       " kończy działanie."); 
  } 
} 
 
class PriorityDemo { 
  public static void main(String[] args) { 
    Priority mt1 = new Priority("Wątek o wysokim priorytecie"); 
    Priority mt2 = new Priority("Wątek o niskim priorytecie"); 
    Priority mt3 = new Priority("Wątek nr 1 o normalnym priorytecie"); 
    Priority mt4 = new Priority("Wątek nr 2 o normalnym priorytecie"); 
    Priority mt5 = new Priority("Wątek nr 3 o normalnym priorytecie");  

    // Określa priorytety wątków
    mt1.thrd.setPriority(Thread.NORM_PRIORITY+2);
    mt2.thrd.setPriority(Thread.NORM_PRIORITY-2); 
    // Wątki mt3, mt4 i mt5 będą działać z normalnym priorytetem 
 
    // Uruchamia działanie wątków
    mt1.thrd.start(); 
    mt2.thrd.start(); 
    mt3.thrd.start(); 
    mt4.thrd.start(); 
    mt5.thrd.start(); 

    try { 
      mt1.thrd.join(); 
      mt2.thrd.join(); 
      mt3.thrd.join(); 
      mt4.thrd.join(); 
      mt5.thrd.join(); 
    } 
    catch(InterruptedException exc) { 
      System.out.println("Główny wątek rozpoczyna działanie."); 
    } 
 
    System.out.println("\nWątek o wysokim priorytecie doliczył do " + 
                       mt1.count); 
    System.out.println("Wątek o niskim priorytecie doliczył do " + 
                       mt2.count); 
    System.out.println("1. wątek o normalnym priorytecie doliczył do " + 
                       mt3.count); 
    System.out.println("2. wątek o normalnym priorytecie doliczył do " + 
                       mt4.count); 
    System.out.println("3. wątek o normalnym priorytecie doliczył do " + 
                       mt5.count); 

  } 
}
