// Demonstruje plik o swobodnym dostępie.

// Wymaga JDK 7 lub nowszej wersji.

import java.io.*;
class RandomAccessDemo {
  public static void main(String args[])
  {
    double data[] = { 19.4, 10.1, 123.54, 33.0, 87.9, 74.25 };
    double d;

    // Otwiera i używa plik o swobodnym dostępie.
    try (RandomAccessFile raf = new RandomAccessFile("random.dat", "rw"))
    {
      // Zapisuje w pliku wartości z tablicy data.
      for(int i=0; i < data.length; i++) {
        raf.writeDouble(data[i]);
      }

      // Teraz odczytuje poszczególne wartości.
      raf.seek(0); // odczytuje pierwszą wartość
      d = raf.readDouble();
      System.out.println("Pierwsza wartość: " + d);

      raf.seek(8); // odczytuje drugą wartość
      d = raf.readDouble();
      System.out.println("Druga wartość: " + d);

      raf.seek(8 * 3); // odczytuje czwartą wartość
      d = raf.readDouble();
      System.out.println("Czwarta wartość: " + d);

      System.out.println();

      // Teraz odczytuje co drugą wartość.
      System.out.println("Co druga wartość: ");
      for(int i=0; i < data.length; i+=2) {
        raf.seek(8 * i); // przesuwa wskaźnik do i-tej wartości double
        d = raf.readDouble();
        System.out.print(d + " ");
      }
    }
    catch(IOException exc) {
      System.out.println("Błąd wejścia/wyjścia: " + exc);
    }
  }
}
