// Prosty program narzędziowy.
// Zapisuje tekst wprowadzany z klawiatury w pliku dyskowym. 
// Demonstruje użycie strumienia znakowego FileWriter.

// Wymaga JDK 7 lub nowszej wersji.

import java.io.*;
class KtoD {
  public static void main(String args[])
  {
    String str;
    BufferedReader br =
            new BufferedReader(
                  new InputStreamReader(System.in));

    System.out.println("Wprowadź tekst ('stop' aby zakończyć).");

    try (FileWriter fw = new FileWriter("test.txt"))
    {
      do {
        System.out.print(": ");
        str = br.readLine();
        if(str.compareTo("stop") == 0) break;

        str = str + "\r\n"; // rozpoczyna nowy wiersz
        fw.write(str);
      } while(str.compareTo("stop") != 0);
    } catch(IOException exc) {
      System.out.println("Błąd wejścia/wyjścia: " + exc);
    }
  }
}
