// Sparametryzowna wersja stosu. 
 
interface IGenStack<T> { 
  void push(T obj) throws StackFullException; 
  T pop() throws StackEmptyException; 
} 
 
// Wyjątek przepełnienia stosu.  
class StackFullException extends Exception {   
  int size;   
     
  StackFullException(int s) { size = s; }   
   
  public String toString() {   
   return "\nStos jest pełen. Maksymalny rozmiar: " +   
           size;   
  }   
}   
   
// Wyjątek opróżnienia stosu.  
class StackEmptyException extends Exception { 
   
  public String toString() {   
   return "\nStos jest pusty.";   
  }   
}   
   
// Sparametryzowana klas stosu.     
class GenStack<T> implements IGenStack<T> {  
  private T stck[]; // tablica przechowująca elementy stosu 
  private int tos;  // szczyt stosu   
     
  // Tworzy stos wykorzystując podaną tablicę. 
  GenStack(T[] stckArray) {     
    stck = stckArray; 
    tos = 0;     
  }     
    
  // Tworzy stos na podstawie innego stosu.
  GenStack(T[] stckArray, GenStack<T> ob) { 
 
    tos = ob.tos;    
    stck = stckArray; 
 
    try { 
      if(stck.length < ob.stck.length) 
        throw new StackFullException(stck.length); 
    } 
    catch(StackFullException exc) {   
      System.out.println(exc);   
    }   
    
    // kopiuje elementy   
    for(int i=0; i < tos; i++)    
      stck[i] = ob.stck[i];    
  }    
    
  // Tworzy stos zawierający podane elementy początkowe. 
  GenStack(T[] stckArray, T[] a) {    
    stck = stckArray; 
    
    for(int i = 0; i < a.length; i++) {    
      try {   
        push(a[i]);    
      }    
      catch(StackFullException exc) {   
        System.out.println(exc);   
      }   
    }        
  }    
       
  // Odkłada obiekt na stosie.
  public void push(T obj) throws StackFullException {     
    if(tos==stck.length)   
      throw new StackFullException(stck.length);   
  
    stck[tos] = obj;    
    tos++;    
  }     
     
  // Zdejmuje obiekt ze stosu. 
  public T pop() throws StackEmptyException {     
    if(tos==0)     
      throw new StackEmptyException();   
       
    tos--;     
    return stck[tos];     
  }     
} 
 
// Demonstruje sparametryzowaną klasę stosu.   
class GenStackDemo {   
  public static void main(String args[]) {   
    // Tworzy pusty stos umożliwiający przechowanie 
    // do 10 elementów typu Integer. 
    Integer iStore[] = new Integer[10]; 
    GenStack<Integer> stk1 = new GenStack<Integer>(iStore); 
  
    // Tworzy stos zawierający podane elementy. 
    String name[] = {"Raz", "Dwa", "Trzy"};   
    String strStore[] = new String[3]; 
    GenStack<String> stk2 = 
        new GenStack<String>(strStore, name); 
  
    String str; 
    int n;   
 
    try { 
   
      // Umieszcza wartości na stosie stk1. 
      for(int i=0; i < 10; i++)   
        stk1.push(i); 
    } catch(StackFullException exc) { 
      System.out.println(exc); 
    } 
  
    // Tworzy stos na podstawie innego stosu. 
    String strStore2[] = new String[3]; 
    GenStack<String> stk3 =  
        new GenStack<String>(strStore2, stk2);  
 
    try {  
      // Wyświetla zawartości stosów.  
      System.out.print("Zawartość stosu stk1: ");   
      for(int i=0; i < 10; i++) {    
        n = stk1.pop();   
        System.out.print(n + " ");   
      }   
   
      System.out.println("\n");   
   
      System.out.print("Zawartość stosu stk2: ");   
      for(int i=0; i < 3; i++) {    
        str = stk2.pop();   
        System.out.print(str + " "); 
      }   
   
      System.out.println("\n");   
   
      System.out.print("Zawartość stosu stk3: ");   
      for(int i=0; i < 3; i++) {    
        str = stk3.pop(); 
        System.out.print(str + " "); 
      }   
 
    } catch(StackEmptyException exc) { 
      System.out.println(exc); 
    } 
 
    System.out.println(); 
  }   
}
