// Program przedstawia tworzenie i stosowanie referencji 
// metod statycznych.
 
// Interfejs funkcyjnych przeznaczony dla predykatów liczbowych
// operujących na wartościach całkowitych.
interface IntPredicate { 
  boolean test(int n); 
} 
 
// Ta klasa definiuje trzy metody statyczne, które sprawdzają 
// określone warunki związane z liczbami całkowitymi. 
class MyIntPredicates { 
  // Metoda statyczna zwracająca wartość true, jeśli przekazana 
  // wartość jest liczbą pierwszą.
  static boolean isPrime(int n) { 
 
    if(n < 2) return false; 
 
    for(int i=2; i <= n/i; i++) { 
      if((n % i) == 0)  
        return false; 
    } 
    return true; 
  } 
 
  // Metoda statyczna zwracająca wartość true, jeśli przekazana 
  // wartość jest parzysta.
  static boolean isEven(int n) { 
    return (n % 2) == 0; 
  } 
 
  // Metoda statyczna zwracająca true, jeśli przekazana wartość
  // jest większa od zera.
  static boolean isPositive(int n) { 
    return n > 0; 
  } 
}     
 
class MethodRefDemo { 
 
  // W tej metodzie typem pierwszego parametru jest interfejs
  // funkcyjny. Oznacza to, że można do niej przekazać referencję
  // dowolnej instancji tego interfejsu, w tym także instancji 
  // utworzonej przez referencję metody.
  static boolean numTest(IntPredicate p, int v) { 
    return p.test(v); 
  } 
 
  public static void main(String args[]) 
  { 
    boolean result; 
     
    // W wywołaniu metody numTest() przekazywana jest referencja
    // metody isPrime().
    result = numTest(MyIntPredicates::isPrime, 17); 
    if(result) System.out.println("17 jest liczbą pierwszą."); 
 
    // Tu przekazywana jest referencja metody isEven(). 
    result = numTest(MyIntPredicates::isEven, 12); 
    if(result) System.out.println("12 jest liczbą parzystą.");  
 
    // I w końcu przekazywana jest referencja metody isPositive. 
    result = numTest(MyIntPredicates::isPositive, 11); 
    if(result) System.out.println("11 jest liczbą większą od 0."); 
  } 
}
