// Modyfikacje klasy MyThread. W tej wersji klasa 
// MyThread tworzy instancję Thread w swoim konstruktorze
// i zapisuje ją w zmiennej składowej o nazwie thrd.
// Określa także nazwę wątku oraz statyczną metodę
// wytwórczą, która tworzy i uruchamia wątek.

class MyThread implements Runnable {
  Thread thrd;

  // Tworzy nowy wątek używając tej implementacj Runnable
  // i nadaje mu nazwę.
  MyThread(String name) {
    thrd = new Thread(this, name);
  }

  // Metoda wytwórcza, która tworzy i uruchamia wątek.
  public static MyThread createAndStart(String name) {
    MyThread myThrd = new MyThread(name);
    
    myThrd.thrd.start(); // uruchamia nowy wątek
    return myThrd;
  }

  // Rozpoczyna wykonywanie nowego wątku.
  public void run() {
    System.out.println(thrd.getName() + " rozpoczyna działanie.");
    try {
      for(int count=0; count<10; count++) {
        Thread.sleep(400);
        System.out.println(thrd.getName() +
              " jest wykonywany, wartość licznika: " + count);
      }
    }
    catch(InterruptedException exc) {
      System.out.println(thrd.getName() + " został przerwany.");
    }
    System.out.println(thrd.getName() + " kończy działanie.");
  }
}

class ThreadVariations {
  public static void main(String args[]) {
    System.out.println("Główny wątek rozpoczyna działanie.");

    MyThread mt = MyThread.createAndStart("Wątek potomny nr 1");

    for(int i=0; i < 50; i++) {
      System.out.print(".");
      try {
        Thread.sleep(100);
      }
      catch(InterruptedException exc) {
        System.out.println("Wątek główny został przerwany.");
      }
    }

    System.out.println("Wątek główny kończy działanie.");
  }
}
