// Prezentacja stosowania przycisków i obsługi zdarzeń 
// w aplikacji JavaFX. 
 
import javafx.application.*; 
import javafx.scene.*; 
import javafx.stage.*; 
import javafx.scene.layout.*; 
import javafx.scene.control.*; 
import javafx.event.*; 
import javafx.geometry.*; 
 
public class JavaFXEventDemo extends Application { 
 
  Label response; 
 
  public static void main(String[] args) { 
 
    // Uruchamia aplikację JavaFX, wywołując metodę launch(). 
    launch(args);   
  } 
 
  // Przesłonięcie metody start(). 
  public void start(Stage myStage) { 
 
    // Określa tytuł obszaru roboczego. 
    myStage.setTitle("Przyciski i zdarzenia JavaFX"); 
 
    // Jako korzeń zostaje użyty panel FlowPane. W tym 
    // przypadku pionowe i poziome odstępy pomiędzy umieszczonymi
    // w nim kontrolkami będą wynosić 10. 
    FlowPane rootNode = new FlowPane(10, 10); 
 
    // Wyrównuje kontrolki do środka.
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt Scene. 
    Scene myScene = new Scene(rootNode, 300, 100); 
 
    // Dodaje obiekt Scene do obiektu Stage. 
    myStage.setScene(myScene); 
 
    // Tworzy etykietę. 
    response = new Label("Przycisk"); 
 
    // Tworzy dwa przyciski. 
    Button btnUp = new Button("Góra"); 
    Button btnDown = new Button("Dół"); 
 
    // Obsługa zdarzenia ActionEvent przycisku Góra.
    btnUp.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        response.setText("Nacisnąłeś przycisk Góra."); 
      } 
    }); 
 
    // Obsługa zdarzenia ActionEvent przycisku Dół.
    btnDown.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        response.setText("Nacisnąłeś przycisk Dół."); 
      } 
    }); 
 
    // Dodaje etykietę i przyciski do grafu sceny.
    rootNode.getChildren().addAll(btnUp, btnDown, response); 
 
    // Wyświetla scenę i obszar roboczy.
    myStage.show(); 
  } 
}
