// Demonstruje pola wyboru. 
  
import java.awt.*;  
import java.awt.event.*;  
import javax.swing.*;  
   
class CBDemo implements ItemListener {  
  
  JLabel jlabSelected; 
  JLabel jlabChanged; 
  JCheckBox jcbAlpha; 
  JCheckBox jcbBeta; 
  JCheckBox jcbGamma; 
  
  CBDemo() {  
    // Tworzy nowy kontener JFrame.  
    JFrame jfrm = new JFrame("Demonstruje pola wyboru");  
  
    // Wybiera FlowLayout jako menedżera układu. 
    jfrm.setLayout(new FlowLayout()); 
  
    // Nadaje oknu początkowe wymiary.  
    jfrm.setSize(280, 120);  
  
    // Aplikacja zakończy działanie na skutek zamknięcia okna.  
    jfrm.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);  
  
    // Tworzy puste etykiety. 
    jlabSelected = new JLabel(""); 
    jlabChanged = new JLabel("");  
  
    // Tworzy pola wyboru.
    jcbAlpha = new JCheckBox("Alfa");  
    jcbBeta = new JCheckBox("Beta");  
    jcbGamma = new JCheckBox("Gamma");  
 
    // Zdarzenia generowane przez pola wyboru 
    // są obsługiwane wspólnie przez metodę itemStateChanged() 
    // implementowaną przez klasę CBDemo. 
    jcbAlpha.addItemListener(this); 
    jcbBeta.addItemListener(this); 
    jcbGamma.addItemListener(this); 
  
    // Umieszcza pola wyboru i etykiety w panelu zawartości.  
    jfrm.add(jcbAlpha);   
    jfrm.add(jcbBeta);   
    jfrm.add(jcbGamma);   
    jfrm.add(jlabChanged);  
    jfrm.add(jlabSelected);  
  
    // Wyświetla okno.  
    jfrm.setVisible(true);  
  }  
 
  // Procedura obsługi zdarzeń związanych z polami wyboru.   
  public void itemStateChanged(ItemEvent ie) { 
    String str = ""; 
 
    // Pobiera referencję pola wyboru, 
    // które wygenerowało zdarzenie. 
    JCheckBox cb = (JCheckBox) ie.getItem(); 
 
    // Informuje, które z pól wyboru zmieniło stan. 
    if(cb.isSelected())  
      jlabChanged.setText(cb.getText() + " zostało zaznaczone."); 
    else 
      jlabChanged.setText(cb.getText() + ": zaznaczenie zostało usunięte."); 
 
    // Informuje, które pola są wybrane. 
    if(jcbAlpha.isSelected()) { 
      str += "Alfa "; 
    }  
    if(jcbBeta.isSelected()) { 
      str += "Beta "; 
    } 
    if(jcbGamma.isSelected()) { 
      str += "Gamma"; 
    } 
 
    jlabSelected.setText("Te pola są wybrane: " + str); 
  } 
 
  public static void main(String args[]) {  
    // Tworzy okno w wątku rozdziału zdarzeń.  
    SwingUtilities.invokeLater(new Runnable() {  
      public void run() {  
        new CBDemo();  
      }  
    });  
  }  
}
