// Tworzenie i stosowanie referencji metod instancyjnych.
 
// Interfejs funkcyjnych przeznaczony dla predykatów liczbowych
// operujących na wartościach całkowitych.
interface IntPredicate { 
  boolean test(int n); 
} 
 
// Ta klasa przechowuje wartość typu int i definiuje 
// metodę instancyjną isFactor(), która zwraca true, jeśli
// przekazany argument jest czynnikiem wartości przechowywanej 
// w obiekcie.
class MyIntNum { 
  private int v; 
 
  MyIntNum(int x) { v = x; } 
 
  int getNum() { return v; } 
 
  // Metoda zwraca true, jeśli n jest czynnikiem v.
  boolean isFactor(int n) { 
    return (v % n) == 0; 
  } 
}     
 
class MethodRefDemo2 { 
 
  public static void main(String args[]) 
  { 
    boolean result; 
 
    MyIntNum myNum = new MyIntNum(12); 
    MyIntNum myNum2 = new MyIntNum(16); 
     
    // Ta instrukcja tworzy referencję metody isFactor obiektu myNum.
    IntPredicate ip = myNum::isFactor; 
 
    // Teraz utworzona wcześniej referencja jest używana do wywołania 
    // metody isFactor() w metodzie test().
    result = ip.test(3); 
    if(result) System.out.println("3 jest czynnikiem liczby " + myNum.getNum()); 
 
 
    // Ten kod tworzy referencję metody isFactor obiektu myNum2. 
    // Referencja ta jest następnie używana do wywołania metody isFactor()
    // wewnątrz metody test(). 
    ip = myNum2::isFactor; 
    result = ip.test(3); 
    if(!result) System.out.println("3 nie jest czynnikiem liczby " + myNum2.getNum()); 
  } 
}
