// Przykład 12.1

// Sumulacja sygnalizacji świetlnej 
// wykorzystująca wyliczenie kolorów światła. 
 
// Wyliczenie stanów sygnalizatora. 
enum TrafficLightColor {  
  CZERWONE, ZIELONE, ZOLTE 
} 
 
// Skomputeryzowana sygnalizacja świetlna. 
class TrafficLightSimulator implements Runnable { 
  private TrafficLightColor tlc; // przechowuje bieżący kolor światła
  boolean stop = false; // wartość true zatrzymuje symulację
  boolean changed = false; // ma wartość true gdy światło zmieniło się
 
  TrafficLightSimulator(TrafficLightColor init) {  
    tlc = init; 
  } 
 
  TrafficLightSimulator() {  
    tlc = TrafficLightColor.CZERWONE; 
  } 
 
  // Rozpoczyna symulację. 
  public void run() { 
    while(!stop) { 
      try { 
        switch(tlc) { 
          case ZIELONE: 
            Thread.sleep(10000); // zielone przez 10 sekund 
            break; 
          case ZOLTE: 
            Thread.sleep(2000);  // zółte przez 2 sekundy
            break; 
          case CZERWONE: 
            Thread.sleep(12000); // czerwone przez 12 sekund
            break; 
        } 
      } catch(InterruptedException exc) { 
        System.out.println(exc); 
      } 
      changeColor(); 
    }  
  } 
 
  // Zmienia kolor. 
  synchronized void changeColor() { 
    switch(tlc) { 
      case CZERWONE: 
        tlc = TrafficLightColor.ZIELONE; 
        break; 
      case ZOLTE: 
        tlc = TrafficLightColor.CZERWONE; 
        break; 
      case ZIELONE: 
       tlc = TrafficLightColor.ZOLTE; 
    } 
 
    changed = true;
    notify(); // sygnalizuje, że światlo zmieniło się
  } 
 
  // Czeka na zmianę światła. 
  synchronized void waitForChange() { 
    try { 
      while(!changed) 
        wait(); // Czeka na zmianę światła.
      changed = false;
    } catch(InterruptedException exc) { 
      System.out.println(exc); 
    } 
  } 
 
  // Zwraca bieżący kolor światła. 
  synchronized TrafficLightColor getColor() { 
    return tlc; 
  } 
 
  // Zatrzymuje sygnalizację. 
  synchronized void cancel() { 
    stop = true; 
  } 
}  
  
class TrafficLightDemo {  
  public static void main(String args[]) {  
    TrafficLightSimulator tl =
      new TrafficLightSimulator(TrafficLightColor.ZIELONE); 
 
    Thread thrd = new Thread(tl);
    thrd.start();
    
    for(int i=0; i < 9; i++) { 
      System.out.println(tl.getColor()); 
      tl.waitForChange(); 
    } 
 
    tl.cancel(); 
  }  
}
