// Automatyczne opakowywanie i wypakowywanie  
// zachodzi w przypadku parametrów metod 
// i wartości zwracanych przez metody.  
  
class AutoBox2 {  
  // Parametr tej metody jest typu Integer. 
  static void m(Integer v) {  
    System.out.println("Metoda m() otrzymała wartość " + v); 
  }   
  
  // Ta metoda zwraca wartość typu int. 
  static int m2() { 
    return 10; 
  } 
 
  // Ta metoda zwraca obiekt typu Integer. 
  static Integer m3() { 
    return 99; // automatycznie opakowuje wartość 99 obiektem Integer. 
  } 
 
  public static void main(String args[]) { 
 
    // Przekazuje wartość typu int metodzie m().  Because m() has an Integer 
    // Ponieważ metoda m() ma parametr typu Integer, 
    // przekazywana wartość typu int zostaje automatycznie opakowana. 
    m(199); 
 
    // W tym przypadku obiekt iOb otrzymuje wartość typu int 
    // zwróconą przez metodę m2(). Aby operacja przypisania 
    // była możliwa, wartość zostaje automatycznie opakowana.
    Integer iOb = m2();   
    System.out.println("Metoda m2() zwróciła wartość " + iOb);  
 
    // Następnie wywołuje metodę m3(). Zwraca ona obiekt typu Integer,
    // z którego zostaje automatycznie wypakowana wartość int. 
    int i = m3(); 
    System.out.println("Metoda m3() zwróciła wartość " + i);  
 
    // Na koniec wywołuje metodę Math.sqrt() przekazując jej obiekt iOb 
    // jako argument wywołania. W tym przypadku wartość obiektu iOb 
    // zostaje automatycznie wypakowana i promowana do typu double
    // wymaganego przez metodę sqrt(). 
    iOb = 100; 
    System.out.println("Pierwiastek kwadratowy z wartości iOb wynosi " + Math.sqrt(iOb)); 
  }  
}
