// Wstrzymywanie, wznawianie i zatrzymywanie wątku. 
 
class MyThread implements Runnable {  
  Thread thrd;  
  boolean suspended;  
  boolean stopped; 
    
  MyThread(String name) {  
    thrd = new Thread(this, name);  
    suspended = false;  
    stopped = false; 
  }  
  
  // Metoda wytwórcza, która tworzy i uruchamia wątek.
  public static MyThread createAndStart(String name) {
    MyThread myThrd = new MyThread(name);
    
    myThrd.thrd.start(); // uruchamia nowy wątek
    return myThrd;
  }  

  // Punkt wejścia do wątku.  
  public void run() {  
    System.out.println(thrd.getName() + " rozpoczyna działanie."); 
    try {  
      for(int i = 1; i < 1000; i++) {  
        System.out.print(i + " ");  
        if((i%10)==0) { 
          System.out.println(); 
          Thread.sleep(250); 
        } 
 
        // Używa bloku synchronized aby sprawdzić 
        // wartośći składowych suspended i stopped. 
        synchronized(this) {  
          while(suspended) {  
            wait();  
          }  
          if(stopped) break; 
        }  
      }  
    } catch (InterruptedException exc) {  
      System.out.println(thrd.getName() + " został przerwany.");  
    }  
    System.out.println(thrd.getName() + " kończy działanie.");  
  }  
 
  // Zatrzymuje wątek.  
  synchronized void mystop() {  
    stopped = true;  
 
   // Poniższe instrukcje umożliwiają zatrzymanie wątku,
   // którego wykonanie zostało wstrzymane. 
    suspended = false; 
    notify(); 
  }  
 
  // Wstrzymuje działanie wątku. 
  synchronized void mysuspend() {  
    suspended = true;  
  }  
 
  // Wznawia działanie wątku.  
  synchronized void myresume() {  
    suspended = false;  
    notify();  
  }  
}  
  
class Suspend {  
  public static void main(String args[]) {  
    MyThread mt1 = MyThread.createAndStart("Wątek potomny klasy MyThread");  
 
    try {  
      Thread.sleep(1000); // umożliwia rozpoczęcie wykonywania wątku mt1
  
      mt1.mysuspend();  
      System.out.println("Wstrzymuję wątek.");  
      Thread.sleep(1000); 
 
      mt1.myresume();  
      System.out.println("Wznawiam wątek.");  
      Thread.sleep(1000); 
 
      mt1.mysuspend();  
      System.out.println("Wstrzymuję wątek.");  
      Thread.sleep(1000); 
 
      mt1.myresume();  
      System.out.println("Wznawiam wątek.");  
      Thread.sleep(1000); 
 
      mt1.mysuspend();  
      System.out.println("Zatrzymuję wątek."); 
      mt1.mystop(); 
    } catch (InterruptedException e) {  
      System.out.println("Wątek główny został przerwany");  
    }  
  
    // czeka na zakończenie wątku  
    try {  
      mt1.thrd.join();  
    } catch (InterruptedException e) {  
      System.out.println("Wątek główny został przerwany");  
    }  
   
    System.out.println("Wątek główny kończy działanie.");  
  }  
}