// Tworzy wiele wątków.

class MyThread implements Runnable {
  Thread thrd;

  // Tworzy nowy wątek.
  MyThread(String name) {
    thrd = new Thread(this, name);
  }

  // Metoda wytwórcza, która tworzy i uruchamia wątek.
  public static MyThread createAndStart(String name) {
    MyThread myThrd = new MyThread(name);
    
    myThrd.thrd.start(); // uruchamia nowy wątek
    return myThrd;
  }

  // Rozpoczyna wykonywanie nowego wątku.
  public void run() {
    System.out.println(thrd.getName() + " rozpoczyna działanie.");
    try {
      for(int count=0; count < 10; count++) {
        Thread.sleep(400);
        System.out.println(thrd.getName() +
                           " jest wykonywany, wartość licznika: " + count);
      }
    }
    catch(InterruptedException exc) {
      System.out.println(thrd.getName() + " został przerwany.");
    }
    System.out.println(thrd.getName() + " kończy działanie.");
  }
}

// Używa isAlive(). 
class MoreThreads2 { 
  public static void main(String args[]) { 
    System.out.println("Główny wątek rozpoczyna działanie."); 
 
    MyThread mt1 = MyThread.createAndStart("Wątek potomny nr 1"); 
    MyThread mt2 = MyThread.createAndStart("Wątek potomny nr 2"); 
    MyThread mt3 = MyThread.createAndStart("Wątek potomny nr 3"); 
 
    do { 
      System.out.print("."); 
      try { 
        Thread.sleep(100); 
      } 
      catch(InterruptedException exc) { 
        System.out.println("Wątek główny został przerwany."); 
      } 
    } while (mt1.thrd.isAlive() || 
             mt2.thrd.isAlive() || 
             mt3.thrd.isAlive()); 
 
    System.out.println("Wątek główny kończy działanie."); 
  } 
}
