// Kolejka znaków o stałym rozmiarze.    
class FixedQueue implements ICharQ {    
  private char q[]; // tablica przechowująca elementy kolejki    
  private int putloc, getloc; // indeksy operacji put i get
    
  // Tworzy pustą kolejkę o podanym rozmiarze.
  public FixedQueue(int size) {    
    q = new char[size]; // przydziela pamięć kolejce 
    putloc = getloc = 0;
  }    
   
  // Umieszcza znak w kolejce.
  public void put(char ch) {
    if(putloc==q.length) { 
      System.out.println(" -- Kolejka pełna.");    
      return;    
    }    
        
    q[putloc++] = ch;    
  }    
    
  // Pobiera znak z kolejki.   
  public char get() {    
    if(getloc == putloc) {    
      System.out.println(" -- Kolejka pusta.");    
      return (char) 0;     
    }    
      
    return q[getloc++];    
  }    
}

// Kolejka cykliczna. 
class CircularQueue implements ICharQ {    
  private char q[]; // tablica przechowująca elementy kolejki 
  private int putloc, getloc; // indeksy operacji put i get
    
  // Tworzy pustą kolejkę o podanym rozmiarze. 
  public CircularQueue(int size) {    
    q = new char[size+1]; // przydziela pamięć kolejce    
    putloc = getloc = 0;    
  }    
   
  // Umieszcza znak w kolejce.    
  public void put(char ch) {    
    /* Kolejka jest pełna, jeśli putloc ma wartość mniejszą 
      o jeden niż getloc lub gdy putloc wskazuje koniec tablicy, 
      a getloc początek. */ 
    if(putloc+1==getloc | 
       ((putloc==q.length-1) & (getloc==0))) {    
      System.out.println(" -- Kolejka pełna.");    
      return;    
    }    
        
    q[putloc++] = ch;    
    if(putloc==q.length) putloc = 0; // powrót na początek tablicy
  }    
    
  // Pobiera znak z kolejki.   
  public char get() {    
    if(getloc == putloc) {    
      System.out.println(" -- Kolejka pusta.");    
      return (char) 0;     
    }    
      
    char ch = q[getloc++];    
    if(getloc==q.length) getloc = 0; // powrót na początek tablicy
    return ch;    
  }    
}


// Kolejka dynamiczna. 
class DynQueue implements ICharQ {    
  private char q[]; // tablica przechowująca elementy kolejki    
  private int putloc, getloc; // indeksy operacji put i get
    
  // Tworzy pustą kolejkę o podanym rozmiarze.   
  public DynQueue(int size) {    
    q = new char[size]; // przydziela pamięć kolejce    
    putloc = getloc = 0;    
  }    
   
  // Umieszcza znak w kolejce.    
  public void put(char ch) {    
    if(putloc==q.length) {    
      // zwiększa rozmiar kolejki 
      char t[] = new char[q.length * 2]; 
 
      // kopiuje elementy do nowej kolejki 
      for(int i=0; i < q.length; i++) 
        t[i] = q[i]; 
 
      q = t; 
    }    
        
    q[putloc++] = ch;    
  }    
    
  // Pobiera znak z kolejki.
  public char get() { 
    if(getloc == putloc) { 
      System.out.println(" -- Kolejka pusta."); 
      return (char) 0;     
    }    
      
    return q[getloc++]; 
  }    
}


// Demonstruje interfejs ICharQ.    
class IQDemo {    
  public static void main(String args[]) {    
    FixedQueue q1 = new FixedQueue(10);    
    DynQueue q2 = new DynQueue(5); 
    CircularQueue q3 = new CircularQueue(10); 
 
    ICharQ iQ; 
 
    char ch;    
    int i;    
 
    iQ = q1;    
    // Umieszcza znaki w kolejce o stałym rozmiarze.    
    for(i=0; i < 10; i++)    
      iQ.put((char) ('A' + i));    
   
    // Wyświetla zawartość kolejki. 
    System.out.print("Zawartość kolejki o stałym rozmiarze: ");    
    for(i=0; i < 10; i++) {     
      ch = iQ.get();    
      System.out.print(ch);    
    } 
    System.out.println(); 
 
    iQ = q2; 
    // Umieszcza znaki w kolejce dynamicznej.    
    for(i=0; i < 10; i++)    
      iQ.put((char) ('Z' - i));    
   
    // Wyświetla zawartość kolejki. 
    System.out.print("Zawartość kolejki dynamicznej: ");    
    for(i=0; i < 10; i++) {     
      ch = iQ.get();    
      System.out.print(ch);    
    }    
 
    System.out.println(); 
 
    iQ = q3; 
    // Umieszcza znaki w kolejce cyklicznej.    
    for(i=0; i < 10; i++)    
      iQ.put((char) ('A' + i));    
   
    // Wyświetla zawartość kolejki. 
    System.out.print("Zawartość kolejki cyklicznej: ");    
    for(i=0; i < 10; i++) {     
      ch = iQ.get();    
      System.out.print(ch);    
    }    
 
    System.out.println(); 
 
    // Umieszcza więcej znaków w kolejce cyklicznej.    
    for(i=10; i < 20; i++)    
      iQ.put((char) ('A' + i));    
 
    // Wyświetla zawartość kolejki. 
    System.out.print("Zawartość kolejki cyklicznej: ");    
    for(i=0; i < 10; i++) {     
      ch = iQ.get();    
      System.out.print(ch);    
    }    
 
    System.out.println("\nUmieszczam i pobieram znak" + 
                       " z kolejki cyklicznej."); 
 
    // Umieszcza i pobiera znak. 
    for(i=0; i < 20; i++) { 
      iQ.put((char) ('A' + i));    
      ch = iQ.get();    
      System.out.print(ch);    
    }    
 
  }    
}
